/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.ir;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.AbstractIRObject;

@Beta
public abstract class IRKeyword
extends AbstractIRObject {
    private final @NonNull String identifier;

    IRKeyword(String localName) {
        this.identifier = Objects.requireNonNull(localName);
    }

    public final @NonNull String identifier() {
        return this.identifier;
    }

    public abstract @Nullable String prefix();

    public abstract @NonNull String asStringDeclaration();

    @Beta
    public static final class Unqualified
    extends IRKeyword {
        Unqualified(String localName) {
            super(localName);
        }

        @Override
        public String prefix() {
            return null;
        }

        @Override
        public String asStringDeclaration() {
            return this.identifier();
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return sb.append(this.identifier());
        }
    }

    @Beta
    public static final class Qualified
    extends IRKeyword {
        private final @NonNull String prefix;

        Qualified(String prefix, String localName) {
            super(localName);
            this.prefix = Objects.requireNonNull(prefix);
        }

        @Override
        public @NonNull String prefix() {
            return this.prefix;
        }

        @Override
        public String asStringDeclaration() {
            return this.prefix + ":" + this.identifier();
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return sb.append(this.prefix).append(':').append(this.identifier());
        }
    }
}

