/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.ir;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.AbstractIRObject;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRArgument;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRKeyword;

@Beta
public abstract class IRStatement
extends AbstractIRObject {
    private final @NonNull IRKeyword keyword;
    private final IRArgument argument;

    IRStatement(IRKeyword keyword, IRArgument argument) {
        this.keyword = Objects.requireNonNull(keyword);
        this.argument = argument;
    }

    public final @NonNull IRKeyword keyword() {
        return this.keyword;
    }

    public final @Nullable IRArgument argument() {
        return this.argument;
    }

    public @NonNull List<? extends IRStatement> statements() {
        return ImmutableList.of();
    }

    public abstract int startLine();

    public abstract int startColumn();

    @Override
    final StringBuilder toYangFragment(StringBuilder sb) {
        List<? extends IRStatement> statements;
        this.keyword.toYangFragment(sb);
        if (this.argument != null) {
            this.argument.toYangFragment(sb.append(' '));
        }
        if ((statements = this.statements()).isEmpty()) {
            return sb.append(';');
        }
        sb.append(" {\n");
        for (IRStatement iRStatement : statements) {
            iRStatement.toYangFragment(sb).append('\n');
        }
        return sb.append('}');
    }
}

