/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.namespace;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;

final class StmtNamespaceContext
implements YangNamespaceContext {
    private static final long serialVersionUID = 1L;
    private final ImmutableBiMap<QNameModule, String> moduleToPrefix;
    private final ImmutableMap<String, QNameModule> prefixToModule;

    StmtNamespaceContext(StmtContext<?, ?, ?> ctx) {
        Map qnameToPrefix = ctx.getAllFromNamespace(ModuleQNameToPrefix.class);
        this.moduleToPrefix = qnameToPrefix == null ? ImmutableBiMap.of() : ImmutableBiMap.copyOf((Map)qnameToPrefix);
        Map imports = ctx.getAllFromNamespace(ImportPrefixToModuleCtx.class);
        if (imports != null) {
            HashMap<String, QNameModule> additional = new HashMap<String, QNameModule>();
            for (Map.Entry entry : imports.entrySet()) {
                if (this.moduleToPrefix.containsValue(entry.getKey())) continue;
                QNameModule qnameModule = (QNameModule)ctx.getFromNamespace(ModuleCtxToModuleQName.class, (Object)((StmtContext)entry.getValue()));
                if (qnameModule == null && ctx.producesDeclared(SubmoduleStatement.class)) {
                    String moduleName = (String)ctx.getFromNamespace(BelongsToPrefixToModuleName.class, (Object)((String)entry.getKey()));
                    qnameModule = (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, (Object)moduleName);
                }
                if (qnameModule == null) continue;
                additional.put((String)entry.getKey(), qnameModule);
            }
            this.prefixToModule = ImmutableMap.copyOf(additional);
        } else {
            this.prefixToModule = ImmutableMap.of();
        }
    }

    public Optional<String> findPrefixForNamespace(QNameModule namespace) {
        return Optional.ofNullable((String)this.moduleToPrefix.get((Object)namespace));
    }

    public Optional<QNameModule> findNamespaceForPrefix(String prefix) {
        QNameModule normal = (QNameModule)this.moduleToPrefix.inverse().get((Object)prefix);
        return normal != null ? Optional.of(normal) : Optional.ofNullable((QNameModule)this.prefixToModule.get((Object)prefix));
    }
}

