/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.AntlrSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRArgument;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class ArgumentContextUtils {
    private ArgumentContextUtils() {
    }

    static @NonNull ArgumentContextUtils forVersion(YangVersion version) {
        switch (version) {
            case VERSION_1: {
                return RFC6020.INSTANCE;
            }
            case VERSION_1_1: {
                return RFC7950.INSTANCE;
            }
        }
        throw new IllegalStateException("Unhandled version " + version);
    }

    static @NonNull ArgumentContextUtils rfc6020() {
        return RFC6020.INSTANCE;
    }

    final @NonNull String stringFromStringContext(IRArgument argument, StatementSourceReference ref) {
        if (argument instanceof IRArgument.Single) {
            IRArgument.Single single = (IRArgument.Single)argument;
            String str = single.string();
            if (single.needQuoteCheck()) {
                this.checkUnquoted(str, ref);
            }
            return single.needUnescape() ? this.unescape(str, ref) : str;
        }
        Verify.verify((boolean)(argument instanceof IRArgument.Concatenation), (String)"Unexpected argument %s", (Object)argument);
        return this.concatStrings(((IRArgument.Concatenation)argument).parts(), ref);
    }

    @Deprecated(forRemoval=true)
    final @NonNull String stringFromStringContext(YangStatementParser.ArgumentContext context, StatementSourceReference ref) {
        ParseTree firstChild = context.getChild(0);
        if (firstChild instanceof TerminalNode) {
            Token token = ((TerminalNode)firstChild).getSymbol();
            switch (token.getType()) {
                case 5: {
                    return firstChild.getText();
                }
                case 10: 
                case 11: 
                case 17: 
                case 18: {
                    return this.decodeQuoted(context, ref);
                }
            }
            throw new VerifyException("Unexpected token " + token);
        }
        Verify.verify((boolean)(firstChild instanceof YangStatementParser.UnquotedStringContext), (String)"Unexpected shape of %s", (Object)context);
        String str = firstChild.getText();
        this.checkUnquoted(str, ref);
        return str;
    }

    @Deprecated
    private @NonNull String decodeQuoted(YangStatementParser.ArgumentContext context, StatementSourceReference ref) {
        if (context.getChildCount() > 2) {
            return this.concatStrings(context, ref);
        }
        ParseTree child = context.getChild(0);
        Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected shape of %s", (Object)context);
        Token token = ((TerminalNode)child).getSymbol();
        switch (token.getType()) {
            case 17: 
            case 18: {
                return "";
            }
            case 11: {
                return token.getText();
            }
            case 10: {
                return this.normalizeDoubleQuoted(token, ref);
            }
        }
        throw new VerifyException("Unhandled token " + token);
    }

    private @NonNull String concatStrings(List<? extends IRArgument.Single> parts, StatementSourceReference ref) {
        StringBuilder sb = new StringBuilder();
        for (IRArgument.Single single : parts) {
            String str = single.string();
            sb.append(single.needUnescape() ? this.unescape(str, ref) : str);
        }
        return sb.toString();
    }

    @Deprecated
    private String concatStrings(YangStatementParser.ArgumentContext context, StatementSourceReference ref) {
        StringBuilder sb = new StringBuilder();
        block5: for (ParseTree child : context.children) {
            Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected argument component %s", (Object)child);
            Token token = ((TerminalNode)child).getSymbol();
            switch (token.getType()) {
                case 4: 
                case 7: 
                case 17: 
                case 18: {
                    continue block5;
                }
                case 11: {
                    sb.append(token.getText());
                    continue block5;
                }
                case 10: {
                    sb.append(this.normalizeDoubleQuoted(token, ref));
                    continue block5;
                }
            }
            throw new VerifyException("Unexpected token " + token);
        }
        return sb.toString();
    }

    @Deprecated
    private String normalizeDoubleQuoted(Token token, StatementSourceReference ref) {
        String stripped = AntlrSupport.trimWhitespace(token.getText(), token.getCharPositionInLine() - 1);
        int backslash = stripped.indexOf(92);
        return backslash == -1 ? stripped : this.unescape(ref, stripped, backslash);
    }

    abstract void checkDoubleQuoted(String var1, StatementSourceReference var2, int var3);

    abstract void checkUnquoted(String var1, StatementSourceReference var2);

    private @NonNull String unescape(String str, StatementSourceReference ref) {
        int backslash = str.indexOf(92);
        return backslash == -1 ? str : this.unescape(ref, str, backslash);
    }

    private @NonNull String unescape(StatementSourceReference ref, String str, int backslash) {
        this.checkDoubleQuoted(str, ref, backslash);
        StringBuilder sb = new StringBuilder(str.length());
        ArgumentContextUtils.unescapeBackslash(sb, str, backslash);
        return sb.toString();
    }

    @VisibleForTesting
    static void unescapeBackslash(StringBuilder sb, String str, int backslash) {
        block2: {
            String substring = str;
            int backslashIndex = backslash;
            while (true) {
                int nextIndex = backslashIndex + 1;
                if (backslashIndex == -1 || nextIndex >= substring.length()) break;
                ArgumentContextUtils.replaceBackslash(sb, substring, nextIndex);
                substring = substring.substring(nextIndex + 1);
                if (substring.length() > 0) {
                    backslashIndex = substring.indexOf(92);
                    continue;
                }
                break block2;
                break;
            }
            sb.append(substring);
        }
    }

    private static void replaceBackslash(StringBuilder sb, String str, int nextAfterBackslash) {
        int backslash = nextAfterBackslash - 1;
        sb.append(str, 0, backslash);
        char c = str.charAt(nextAfterBackslash);
        switch (c) {
            case '\"': 
            case '\\': {
                sb.append(c);
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'n': {
                sb.append('\n');
                break;
            }
            default: {
                sb.append(str, backslash, nextAfterBackslash + 1);
            }
        }
    }

    private static final class RFC7950
    extends ArgumentContextUtils {
        private static final CharMatcher ANYQUOTE_MATCHER = CharMatcher.anyOf((CharSequence)"'\"");
        private static final @NonNull RFC7950 INSTANCE = new RFC7950();

        private RFC7950() {
        }

        @Override
        void checkDoubleQuoted(String str, StatementSourceReference ref, int backslash) {
            if (backslash < str.length() - 1) {
                int index = backslash;
                block3: while (index != -1) {
                    switch (str.charAt(index + 1)) {
                        case '\"': 
                        case '\\': 
                        case 'n': 
                        case 't': {
                            index = str.indexOf(92, index + 2);
                            continue block3;
                        }
                    }
                    throw new SourceException(ref, "YANG 1.1: illegal double quoted string (%s). In double quoted string the backslash must be followed by one of the following character [n,t,\",\\], but was '%s'.", new Object[]{str, Character.valueOf(str.charAt(index + 1))});
                }
            }
        }

        @Override
        void checkUnquoted(String str, StatementSourceReference ref) {
            SourceException.throwIf((boolean)ANYQUOTE_MATCHER.matchesAnyOf((CharSequence)str), (StatementSourceReference)ref, (String)"YANG 1.1: unquoted string (%s) contains illegal characters", (Object[])new Object[]{str});
        }
    }

    private static final class RFC6020
    extends ArgumentContextUtils {
        private static final @NonNull RFC6020 INSTANCE = new RFC6020();

        private RFC6020() {
        }

        @Override
        void checkDoubleQuoted(String str, StatementSourceReference ref, int backslash) {
        }

        @Override
        void checkUnquoted(String str, StatementSourceReference ref) {
        }
    }
}

