/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.antlr.ExplicitTextToken;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRArgument;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRKeyword;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement;

final class IRStatementContext
extends YangStatementParser.StatementContext {
    private static final TerminalNode COLON = new TerminalNodeImpl((Token)new ExplicitTextToken(6, ":"));
    private static final TerminalNode SEMICOLON = new TerminalNodeImpl((Token)new ExplicitTextToken(1, ";"));
    private static final TerminalNode LBRACE = new TerminalNodeImpl((Token)new ExplicitTextToken(2, "{"));
    private static final TerminalNode RBRACE = new TerminalNodeImpl((Token)new ExplicitTextToken(3, "}"));
    private static final TerminalNode PLUS = new TerminalNodeImpl((Token)new ExplicitTextToken(7, "+"));
    private static final TerminalNode SEP = new TerminalNodeImpl((Token)new ExplicitTextToken(4, " "));
    private static final TerminalNode DQUOT_END = new TerminalNodeImpl((Token)new ExplicitTextToken(17, "\""));
    private static final TerminalNode SQUOT_END = new TerminalNodeImpl((Token)new ExplicitTextToken(18, "'"));

    IRStatementContext(IRStatement rootStatement) {
        super(null, -1);
        this.initialize(rootStatement);
    }

    private void initialize(IRStatement stmt) {
        List<? extends IRStatement> stmts;
        ArrayList<ParseTree> tmp = new ArrayList<ParseTree>();
        IRKeyword keyword = stmt.keyword();
        String prefix = keyword.prefix();
        if (prefix != null) {
            this.start = new ExplicitTextToken(5, prefix);
            tmp.add((ParseTree)new TerminalNodeImpl(this.start));
            tmp.add((ParseTree)COLON);
            tmp.add((ParseTree)new TerminalNodeImpl((Token)new ExplicitTextToken(5, keyword.identifier())));
        } else {
            this.start = new ExplicitTextToken(5, keyword.identifier());
            tmp.add((ParseTree)new TerminalNodeImpl(this.start));
        }
        IRArgument argument = stmt.argument();
        if (argument != null) {
            tmp.add((ParseTree)SEP);
            IRStatementContext.addArgumentChildren(tmp, stmt.argument());
        }
        if (!(stmts = stmt.statements()).isEmpty()) {
            tmp.add((ParseTree)LBRACE);
            for (IRStatement iRStatement : stmt.statements()) {
                tmp.add((ParseTree)new IRStatementContext(iRStatement));
            }
            tmp.add((ParseTree)RBRACE);
        } else {
            tmp.add((ParseTree)SEMICOLON);
        }
        this.children = ImmutableList.copyOf(tmp);
    }

    private static void addArgumentChildren(List<ParseTree> children, IRArgument argument) {
        if (argument instanceof IRArgument.Concatenation) {
            Iterator<? extends IRArgument.Single> it = ((IRArgument.Concatenation)argument).parts().iterator();
            IRStatementContext.addArgumentChildren(children, it.next());
            while (it.hasNext()) {
                children.add((ParseTree)PLUS);
                IRStatementContext.addArgumentChildren(children, it.next());
            }
        } else if (argument instanceof IRArgument.Single) {
            IRStatementContext.addArgumentChildren(children, (IRArgument.Single)argument);
        } else {
            throw new IllegalStateException("Unhandled argument " + argument);
        }
    }

    private static void addArgumentChildren(List<ParseTree> children, IRArgument.Single argument) {
        String str = argument.string();
        if (argument.isValidIdentifier()) {
            children.add((ParseTree)new TerminalNodeImpl((Token)new ExplicitTextToken(5, str)));
        } else if (argument.needQuoteCheck()) {
            children.add((ParseTree)new TerminalNodeImpl((Token)new ExplicitTextToken(12, str)));
        } else if (argument.needUnescape()) {
            children.add((ParseTree)new TerminalNodeImpl((Token)new ExplicitTextToken(10, str)));
            children.add((ParseTree)DQUOT_END);
        } else {
            children.add((ParseTree)new TerminalNodeImpl((Token)new ExplicitTextToken(11, str)));
            children.add((ParseTree)SQUOT_END);
        }
    }
}

