/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.SchemaSourceTransformer;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.AntlrSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;

@Beta
public final class TextToIRTransformer
extends SchemaSourceTransformer<YangTextSchemaSource, IRSchemaSource> {
    private TextToIRTransformer(SchemaRepository provider, SchemaSourceRegistry consumer) {
        super(provider, YangTextSchemaSource.class, consumer, IRSchemaSource.class, input -> Futures.immediateFuture((Object)((Object)TextToIRTransformer.transformText(input))));
    }

    public static @NonNull TextToIRTransformer create(SchemaRepository provider, SchemaSourceRegistry consumer) {
        return new TextToIRTransformer(provider, consumer);
    }

    public static @NonNull IRSchemaSource transformText(YangTextSchemaSource text) throws YangSyntaxErrorException, IOException {
        IRStatement rootStatement = AntlrSupport.createStatement(YangStatementStreamSource.parseYangSource(text));
        String name = YangModelDependencyInfo.safeStringArgument(text.getIdentifier(), rootStatement, "name");
        String latestRevision = YangModelDependencyInfo.getLatestRevision(rootStatement, text.getIdentifier());
        RevisionSourceIdentifier sourceId = latestRevision == null ? RevisionSourceIdentifier.create((String)name) : RevisionSourceIdentifier.create((String)name, (Revision)Revision.of((String)latestRevision));
        return new IRSchemaSource((SourceIdentifier)sourceId, rootStatement);
    }
}

