/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractModelStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class AbstractDeclaredStatement<A>
extends AbstractModelStatement<A>
implements DeclaredStatement<A> {
    protected AbstractDeclaredStatement() {
    }

    public StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    public Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return ImmutableList.of();
    }

    protected static final @NonNull ImmutableList<? extends DeclaredStatement<?>> unmaskList(@NonNull Object masked) {
        return AbstractDeclaredStatement.unmaskList(masked, DeclaredStatement.class);
    }

    public static abstract class ArgumentToString<A>
    extends AbstractDeclaredStatement<A> {
        private final @NonNull A argument;

        protected ArgumentToString(A argument) {
            this.argument = Objects.requireNonNull(argument);
        }

        public final @NonNull A argument() {
            return this.argument;
        }

        public final String rawArgument() {
            return this.argument.toString();
        }

        public static abstract class WithSubstatements<A>
        extends ArgumentToString<A> {
            private final @NonNull Object substatements;

            protected WithSubstatements(A argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(argument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithArgument<A>
    extends WithRawArgument<A> {
        private final A argument;

        protected WithArgument(StmtContext<A, ?, ?> context) {
            super(context);
            this.argument = context.getStatementArgument();
        }

        public final A argument() {
            return this.argument;
        }

        public static abstract class WithSubstatements<A>
        extends WithArgument<A> {
            private final @NonNull Object substatements;

            protected WithSubstatements(StmtContext<A, ?, ?> context, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(context);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithRawStringArgument
    extends WithRawArgument<String> {
        protected WithRawStringArgument(StmtContext<String, ?, ?> context) {
            super(context);
        }

        protected WithRawStringArgument(String rawArgument) {
            super(rawArgument);
        }

        public final String argument() {
            return this.rawArgument();
        }

        public static abstract class WithSubstatements
        extends WithRawStringArgument {
            private final @NonNull Object substatements;

            protected WithSubstatements(StmtContext<String, ?, ?> context, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(context);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            protected WithSubstatements(String rawArgument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(rawArgument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithQNameArgument
    extends AbstractDeclaredStatement<QName> {
        private final QName argument;

        protected WithQNameArgument(QName argument) {
            this.argument = Objects.requireNonNull(argument);
        }

        public final @NonNull QName argument() {
            return this.argument;
        }

        public final String rawArgument() {
            return this.argument.getLocalName();
        }

        public static abstract class WithSubstatements
        extends WithQNameArgument {
            private final @NonNull Object substatements;

            protected WithSubstatements(QName argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(argument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithRawArgument<A>
    extends AbstractDeclaredStatement<A> {
        private final String rawArgument;

        protected WithRawArgument(StmtContext<A, ?, ?> context) {
            this(context.rawStatementArgument());
        }

        protected WithRawArgument(String rawArgument) {
            this.rawArgument = rawArgument;
        }

        public final String rawArgument() {
            return this.rawArgument;
        }
    }
}

