/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class BaseBooleanStatementSupport<D extends DeclaredStatement<Boolean>, E extends EffectiveStatement<Boolean, D>>
extends BaseStatementSupport<Boolean, D, E> {
    private final @NonNull E emptyEffectiveFalse;
    private final @NonNull E emptyEffectiveTrue;
    private final @NonNull D emptyDeclaredFalse;
    private final @NonNull D emptyDeclaredTrue;

    protected BaseBooleanStatementSupport(StatementDefinition publicDefinition, E emptyEffectiveFalse, E emptyEffectiveTrue) {
        super(publicDefinition, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
        this.emptyEffectiveFalse = (EffectiveStatement)Objects.requireNonNull(emptyEffectiveFalse);
        this.emptyEffectiveTrue = (EffectiveStatement)Objects.requireNonNull(emptyEffectiveTrue);
        this.emptyDeclaredFalse = Objects.requireNonNull(emptyEffectiveFalse.getDeclared());
        this.emptyDeclaredTrue = Objects.requireNonNull(emptyEffectiveTrue.getDeclared());
    }

    public final Boolean parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.parseBoolean(ctx, value);
    }

    public final String internArgument(String rawArgument) {
        return ArgumentUtils.internBoolean(rawArgument);
    }

    @Override
    protected final D createEmptyDeclared(StmtContext<Boolean, D, ?> ctx) {
        return (Boolean)ctx.coerceStatementArgument() != false ? this.emptyDeclaredTrue : this.emptyDeclaredFalse;
    }

    @Override
    protected final E createEmptyEffective(StmtContext<Boolean, D, E> ctx, D declared) {
        if (this.emptyDeclaredTrue.equals(declared)) {
            return this.emptyEffectiveTrue;
        }
        if (this.emptyDeclaredFalse.equals(declared)) {
            return this.emptyEffectiveFalse;
        }
        return this.createEmptyEffective(declared);
    }

    protected abstract @NonNull E createEmptyEffective(@NonNull D var1);
}

