/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class BaseInternedStatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends BaseStatementSupport<A, D, E> {
    private final LoadingCache<A, D> declaredCache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<A, D>(){

        public D load(A key) {
            return BaseInternedStatementSupport.this.createEmptyDeclared(key);
        }
    });
    private final LoadingCache<D, E> effectiveCache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<D, E>(){

        public E load(D key) throws ExecutionException {
            return BaseInternedStatementSupport.this.createEmptyEffective(key);
        }
    });

    protected BaseInternedStatementSupport(StatementDefinition publicDefinition) {
        super(publicDefinition, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    @Override
    protected final D createEmptyDeclared(StmtContext<A, D, ?> ctx) {
        return (D)((DeclaredStatement)this.declaredCache.getUnchecked(ctx.coerceStatementArgument()));
    }

    protected abstract @NonNull D createEmptyDeclared(@NonNull A var1);

    @Override
    protected final E createEmptyEffective(StmtContext<A, D, E> ctx, D declared) {
        return (E)((EffectiveStatement)this.effectiveCache.getUnchecked(declared));
    }

    protected abstract @NonNull E createEmptyEffective(@NonNull D var1);

    @Override
    protected final D createDeclared(StmtContext<A, D, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return this.createDeclared(ctx.coerceStatementArgument(), substatements);
    }

    protected abstract @NonNull D createDeclared(@NonNull A var1, ImmutableList<? extends DeclaredStatement<?>> var2);
}

