/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class BaseQNameStatementSupport<D extends DeclaredStatement<QName>, E extends EffectiveStatement<QName, D>>
extends AbstractQNameStatementSupport<D, E> {
    protected BaseQNameStatementSupport(StatementDefinition publicDefinition) {
        super(publicDefinition);
    }

    public final D createDeclared(StmtContext<QName, D, ?> ctx) {
        ImmutableList substatements = (ImmutableList)ctx.declaredSubstatements().stream().map(StmtContext::buildDeclared).collect(ImmutableList.toImmutableList());
        return substatements.isEmpty() ? this.createEmptyDeclared(ctx) : this.createDeclared(ctx, substatements);
    }

    protected abstract @NonNull D createDeclared(@NonNull StmtContext<QName, D, ?> var1, @NonNull ImmutableList<? extends DeclaredStatement<?>> var2);

    protected abstract @NonNull D createEmptyDeclared(@NonNull StmtContext<QName, D, ?> var1);

    public E createEffective(StmtContext<QName, D, E> ctx) {
        DeclaredStatement declared = ctx.buildDeclared();
        ImmutableList<EffectiveStatement<QName, QName>> substatements = BaseStatementSupport.buildEffectiveSubstatements(ctx);
        return substatements.isEmpty() ? this.createEmptyEffective(ctx, declared) : this.createEffective(ctx, declared, substatements);
    }

    protected abstract @NonNull E createEffective(@NonNull StmtContext<QName, D, E> var1, @NonNull D var2, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var3);

    protected abstract @NonNull E createEmptyEffective(@NonNull StmtContext<QName, D, E> var1, @NonNull D var2);

    protected static final <E extends EffectiveStatement<?, ?>> @Nullable E findFirstStatement(ImmutableList<? extends EffectiveStatement<?, ?>> statements, Class<E> type) {
        return BaseStatementSupport.findFirstStatement(statements, type);
    }

    protected static final <A, E extends EffectiveStatement<A, ?>> A findFirstArgument(ImmutableList<? extends EffectiveStatement<?, ?>> statements, Class<E> type, A defValue) {
        return BaseStatementSupport.findFirstArgument(statements, type, defValue);
    }

    protected static final int historyAndStatusFlags(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(BaseQNameStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags();
    }
}

