/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.YangNamespaceContextNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.WithExpressionImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParser;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@NonNullByDefault
public final class XPathSupport {
    private static final Logger LOG = LoggerFactory.getLogger(XPathSupport.class);
    private final YangXPathParserFactory factory;

    public XPathSupport(YangXPathParserFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public RevisionAwareXPath parseXPath(StmtContext<?, ?, ?> ctx, String xpath) {
        YangXPathExpression.QualifiedBound parsed;
        boolean isAbsolute = ArgumentUtils.isAbsoluteXPath(xpath);
        YangXPathParser.QualifiedBound parser = this.factory.newParser(YangNamespaceContextNamespace.computeIfAbsent(ctx));
        try {
            parsed = parser.parseExpression(xpath);
        }
        catch (XPathExpressionException e) {
            LOG.warn("Argument \"{}\" is not valid XPath string at \"{}\"", new Object[]{xpath, ctx.getStatementSourceReference(), e});
            return new RevisionAwareXPathImpl(xpath, isAbsolute);
        }
        if (ctx.getRootVersion().compareTo((Enum)parsed.getYangVersion()) < 0) {
            LOG.warn("{} features required in {} context to parse expression '{}' [at {}]", new Object[]{parsed.getYangVersion().getReference(), ctx.getRootVersion().getReference(), xpath, ctx.getStatementSourceReference()});
        }
        return new WithExpressionImpl(xpath, isAbsolute, parsed);
    }
}

