/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anydata;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anydata.EmptyAnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anydata.EmptyAnydataStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anydata.RegularAnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.anydata.RegularAnydataStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class AnydataStatementSupport
extends BaseQNameStatementSupport<AnydataStatement, AnydataEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ANYDATA).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addAny((StatementDefinition)YangStmtMapping.MUST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final AnydataStatementSupport INSTANCE = new AnydataStatementSupport();

    private AnydataStatementSupport() {
        super((StatementDefinition)YangStmtMapping.ANYDATA);
    }

    public static AnydataStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, AnydataStatement, AnydataEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected AnydataStatement createDeclared(StmtContext<QName, AnydataStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularAnydataStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected AnydataStatement createEmptyDeclared(StmtContext<QName, AnydataStatement, ?> ctx) {
        return new EmptyAnydataStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected AnydataEffectiveStatement createEffective(StmtContext<QName, AnydataStatement, AnydataEffectiveStatement> ctx, AnydataStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularAnydataEffectiveStatement(declared, (SchemaPath)ctx.getSchemaPath().get(), AnydataStatementSupport.computeFlags(ctx, substatements), AnydataStatementSupport.findOriginal(ctx), substatements);
    }

    @Override
    protected AnydataEffectiveStatement createEmptyEffective(StmtContext<QName, AnydataStatement, AnydataEffectiveStatement> ctx, AnydataStatement declared) {
        return new EmptyAnydataEffectiveStatement(declared, (SchemaPath)ctx.getSchemaPath().get(), AnydataStatementSupport.computeFlags(ctx, ImmutableList.of()), AnydataStatementSupport.findOriginal(ctx));
    }

    private static int computeFlags(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AnydataStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration()).setMandatory(AnydataStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, Boolean.FALSE)).toFlags();
    }

    private static @Nullable AnydataSchemaNode findOriginal(StmtContext<?, ?, ?> ctx) {
        return ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
    }
}

