/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base.EmptyBaseEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base.EmptyBaseStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base.RegularBaseEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.base.RegularBaseStatement;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class BaseStatementSupport
extends BaseQNameStatementSupport<BaseStatement, BaseEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.BASE).build();
    private static final BaseStatementSupport INSTANCE = new BaseStatementSupport();

    private BaseStatementSupport() {
        super((StatementDefinition)YangStmtMapping.BASE);
    }

    public static BaseStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public void onStatementDefinitionDeclared(final StmtContext.Mutable<QName, BaseStatement, BaseEffectiveStatement> baseStmtCtx) {
        final StmtContext.Mutable baseParentCtx = baseStmtCtx.getParentContext();
        if (baseParentCtx.producesDeclared(IdentityStatement.class)) {
            QName baseIdentityQName = (QName)baseStmtCtx.coerceStatementArgument();
            ModelActionBuilder baseIdentityAction = baseStmtCtx.newInferenceAction(ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.requiresCtx(baseStmtCtx, IdentityNamespace.class, (Object)baseIdentityQName, ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.mutatesCtx(baseParentCtx, ModelProcessingPhase.STATEMENT_DEFINITION);
            baseIdentityAction.apply(new ModelActionBuilder.InferenceAction(){

                public void apply(ModelActionBuilder.InferenceContext ctx) {
                }

                public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                    throw new InferenceException(baseStmtCtx.getStatementSourceReference(), "Unable to resolve identity %s and base identity %s", new Object[]{baseParentCtx.getStatementArgument(), baseStmtCtx.getStatementArgument()});
                }
            });
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected BaseStatement createDeclared(StmtContext<QName, BaseStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularBaseStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected BaseStatement createEmptyDeclared(StmtContext<QName, BaseStatement, ?> ctx) {
        return new EmptyBaseStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected BaseEffectiveStatement createEffective(StmtContext<QName, BaseStatement, BaseEffectiveStatement> ctx, BaseStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularBaseEffectiveStatement(declared, substatements);
    }

    @Override
    protected BaseEffectiveStatement createEmptyEffective(StmtContext<QName, BaseStatement, BaseEffectiveStatement> ctx, BaseStatement declared) {
        return new EmptyBaseEffectiveStatement(declared);
    }
}

