/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to.EmptyBelongsToEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to.EmptyBelongsToStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to.RegularBelongsToEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.belongs_to.RegularBelongsToStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNamespaceForBelongsTo;

public final class BelongsToStatementSupport
extends BaseStringStatementSupport<BelongsToStatement, BelongsToEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.BELONGS_TO).addMandatory((StatementDefinition)YangStmtMapping.PREFIX).build();
    private static final BelongsToStatementSupport INSTANCE = new BelongsToStatementSupport();

    private BelongsToStatementSupport() {
        super((StatementDefinition)YangStmtMapping.BELONGS_TO);
    }

    public static BelongsToStatementSupport getInstance() {
        return INSTANCE;
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<String, BelongsToStatement, BelongsToEffectiveStatement> ctx) {
        ctx.addRequiredSource(BelongsToStatementSupport.getSourceIdentifier(ctx));
    }

    public void onLinkageDeclared(final StmtContext.Mutable<String, BelongsToStatement, BelongsToEffectiveStatement> belongsToCtx) {
        ModelActionBuilder belongsToAction = belongsToCtx.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final SourceIdentifier belongsToSourceIdentifier = BelongsToStatementSupport.getSourceIdentifier(belongsToCtx);
        final ModelActionBuilder.Prerequisite belongsToPrereq = belongsToAction.requiresCtx(belongsToCtx, ModuleNamespaceForBelongsTo.class, (Object)((String)belongsToCtx.coerceStatementArgument()), ModelProcessingPhase.SOURCE_LINKAGE);
        belongsToAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext belongsToModuleCtx = (StmtContext)belongsToPrereq.resolve(ctx);
                belongsToCtx.addToNs(BelongsToModuleContext.class, (Object)belongsToSourceIdentifier, (Object)belongsToModuleCtx);
                belongsToCtx.addToNs(BelongsToPrefixToModuleCtx.class, (Object)((String)StmtContextUtils.findFirstDeclaredSubstatement((StmtContext)belongsToCtx, PrefixStatement.class).coerceStatementArgument()), (Object)belongsToModuleCtx);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (failed.contains(belongsToPrereq)) {
                    throw new InferenceException(belongsToCtx.getStatementSourceReference(), "Module '%s' from belongs-to was not found", new Object[]{belongsToCtx.getStatementArgument()});
                }
            }
        });
    }

    @Override
    protected BelongsToStatement createDeclared(StmtContext<String, BelongsToStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularBelongsToStatement(ctx, substatements);
    }

    @Override
    protected BelongsToStatement createEmptyDeclared(StmtContext<String, BelongsToStatement, ?> ctx) {
        return new EmptyBelongsToStatement(ctx);
    }

    @Override
    protected BelongsToEffectiveStatement createEffective(StmtContext<String, BelongsToStatement, BelongsToEffectiveStatement> ctx, BelongsToStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularBelongsToEffectiveStatement(declared, substatements);
    }

    @Override
    protected BelongsToEffectiveStatement createEmptyEffective(StmtContext<String, BelongsToStatement, BelongsToEffectiveStatement> ctx, BelongsToStatement declared) {
        return new EmptyBelongsToEffectiveStatement(declared);
    }

    private static SourceIdentifier getSourceIdentifier(StmtContext<String, BelongsToStatement, BelongsToEffectiveStatement> belongsToCtx) {
        return RevisionSourceIdentifier.create((String)((String)belongsToCtx.coerceStatementArgument()));
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }
}

