/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.DeviateKind;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviateEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviateStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviate.DeviateEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviate.DeviateStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModulesDeviatedByModules;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDeviateStatementSupport
extends BaseStatementSupport<DeviateKind, DeviateStatement, DeviateEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDeviateStatementSupport.class);
    private static final SubstatementValidator DEVIATE_NOT_SUPPORTED_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).build();
    private static final SubstatementValidator DEVIATE_ADD_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final SubstatementValidator DEVIATE_REPLACE_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).addOptional((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final SubstatementValidator DEVIATE_DELETE_SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addAny((StatementDefinition)YangStmtMapping.MUST).addAny((StatementDefinition)YangStmtMapping.UNIQUE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final ImmutableMap<String, DeviateKind> KEYWORD_TO_DEVIATE_MAP = Maps.uniqueIndex(Arrays.asList(DeviateKind.values()), DeviateKind::getKeyword);
    private static final ImmutableSet<YangStmtMapping> SINGLETON_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.UNITS, (Object)YangStmtMapping.CONFIG, (Object)YangStmtMapping.MANDATORY, (Object)YangStmtMapping.MIN_ELEMENTS, (Object)YangStmtMapping.MAX_ELEMENTS);
    private static final ImmutableSet<YangStmtMapping> IMPLICIT_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.CONFIG, (Object)YangStmtMapping.MANDATORY, (Object)YangStmtMapping.MAX_ELEMENTS, (Object)YangStmtMapping.MIN_ELEMENTS);

    AbstractDeviateStatementSupport() {
        super((StatementDefinition)YangStmtMapping.DEVIATE);
    }

    public final DeviateKind parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (DeviateKind)SourceException.throwIfNull((Object)((DeviateKind)KEYWORD_TO_DEVIATE_MAP.get((Object)value)), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"String '%s' is not valid deviate argument", (Object[])new Object[]{value});
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<DeviateKind, DeviateStatement, DeviateEffectiveStatement> deviateStmtCtx) {
        final DeviateKind deviateKind = (DeviateKind)deviateStmtCtx.getStatementArgument();
        this.getSubstatementValidatorForDeviate(deviateKind).validate(deviateStmtCtx);
        final SchemaNodeIdentifier deviationTarget = (SchemaNodeIdentifier)deviateStmtCtx.coerceParentContext().getStatementArgument();
        if (!AbstractDeviateStatementSupport.isDeviationSupported(deviateStmtCtx, deviationTarget)) {
            return;
        }
        ModelActionBuilder deviateAction = deviateStmtCtx.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite sourceCtxPrerequisite = deviateAction.requiresCtx(deviateStmtCtx, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite targetCtxPrerequisite = deviateAction.mutatesEffectiveCtxPath((StmtContext)deviateStmtCtx.getRoot(), ChildSchemaNodeNamespace.class, (Iterable)deviationTarget.getNodeIdentifiers());
        deviateAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StatementContextBase sourceNodeStmtCtx = (StatementContextBase)sourceCtxPrerequisite.resolve(ctx);
                StatementContextBase targetNodeStmtCtx = (StatementContextBase)targetCtxPrerequisite.resolve(ctx);
                switch (deviateKind) {
                    case NOT_SUPPORTED: {
                        targetNodeStmtCtx.setIsSupportedToBuildEffective(false);
                        break;
                    }
                    case ADD: {
                        AbstractDeviateStatementSupport.performDeviateAdd(sourceNodeStmtCtx, targetNodeStmtCtx);
                        break;
                    }
                    case REPLACE: {
                        AbstractDeviateStatementSupport.performDeviateReplace(sourceNodeStmtCtx, targetNodeStmtCtx);
                        break;
                    }
                    case DELETE: {
                        AbstractDeviateStatementSupport.performDeviateDelete(sourceNodeStmtCtx, targetNodeStmtCtx);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported deviate " + deviateKind);
                    }
                }
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                throw new InferenceException(deviateStmtCtx.coerceParentContext().getStatementSourceReference(), "Deviation target '%s' not found.", new Object[]{deviationTarget});
            }
        });
    }

    public String internArgument(String rawArgument) {
        if ("add".equals(rawArgument)) {
            return "add";
        }
        if ("delete".equals(rawArgument)) {
            return "delete";
        }
        if ("replace".equals(rawArgument)) {
            return "replace";
        }
        if ("not-supported".equals(rawArgument)) {
            return "not-supported";
        }
        return rawArgument;
    }

    protected final SubstatementValidator getSubstatementValidator() {
        return null;
    }

    @Override
    protected final DeviateStatement createDeclared(StmtContext<DeviateKind, DeviateStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new DeviateStatementImpl(ctx, substatements);
    }

    @Override
    protected final DeviateStatement createEmptyDeclared(StmtContext<DeviateKind, DeviateStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    @Override
    protected final DeviateEffectiveStatement createEffective(StmtContext<DeviateKind, DeviateStatement, DeviateEffectiveStatement> ctx, DeviateStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new DeviateEffectiveStatementImpl(declared, substatements);
    }

    @Override
    protected final DeviateEffectiveStatement createEmptyEffective(StmtContext<DeviateKind, DeviateStatement, DeviateEffectiveStatement> ctx, DeviateStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    protected SubstatementValidator getSubstatementValidatorForDeviate(DeviateKind deviateKind) {
        switch (deviateKind) {
            case NOT_SUPPORTED: {
                return DEVIATE_NOT_SUPPORTED_SUBSTATEMENT_VALIDATOR;
            }
            case ADD: {
                return DEVIATE_ADD_SUBSTATEMENT_VALIDATOR;
            }
            case REPLACE: {
                return DEVIATE_REPLACE_SUBSTATEMENT_VALIDATOR;
            }
            case DELETE: {
                return DEVIATE_DELETE_SUBSTATEMENT_VALIDATOR;
            }
        }
        throw new IllegalStateException(String.format("Substatement validator for deviate %s has not been defined.", deviateKind));
    }

    private static boolean isDeviationSupported(StmtContext.Mutable<DeviateKind, DeviateStatement, DeviateEffectiveStatement> deviateStmtCtx, SchemaNodeIdentifier deviationTarget) {
        SetMultimap modulesDeviatedByModules = (SetMultimap)deviateStmtCtx.getFromNamespace(ModulesDeviatedByModules.class, (Object)ModulesDeviatedByModules.SupportedModules.SUPPORTED_MODULES);
        if (modulesDeviatedByModules == null) {
            return true;
        }
        QNameModule currentModule = (QNameModule)deviateStmtCtx.getFromNamespace(ModuleCtxToModuleQName.class, (Object)deviateStmtCtx.getRoot());
        QNameModule targetModule = ((QName)Iterables.getLast((Iterable)deviationTarget.getNodeIdentifiers())).getModule();
        Set deviationModulesSupportedByTargetModule = modulesDeviatedByModules.get((Object)targetModule);
        if (deviationModulesSupportedByTargetModule != null) {
            return deviationModulesSupportedByTargetModule.contains(currentModule);
        }
        return false;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void performDeviateAdd(StatementContextBase<?, ?, ?> deviateStmtCtx, StatementContextBase<?, ?, ?> targetCtx) {
        for (StmtContext.Mutable originalStmtCtx : deviateStmtCtx.mutableDeclaredSubstatements()) {
            AbstractDeviateStatementSupport.validateDeviationTarget(originalStmtCtx, targetCtx);
            AbstractDeviateStatementSupport.addStatement(originalStmtCtx, targetCtx);
        }
    }

    private static void addStatement(StmtContext.Mutable<?, ?, ?> stmtCtxToBeAdded, StatementContextBase<?, ?, ?> targetCtx) {
        StatementDefinition stmtToBeAdded;
        if (!StmtContextUtils.isUnknownStatement(stmtCtxToBeAdded) && (SINGLETON_STATEMENTS.contains((Object)(stmtToBeAdded = stmtCtxToBeAdded.getPublicDefinition())) || YangStmtMapping.DEFAULT.equals((Object)stmtToBeAdded) && YangStmtMapping.LEAF.equals((Object)targetCtx.getPublicDefinition()))) {
            for (StmtContext targetCtxSubstatement : targetCtx.allSubstatements()) {
                InferenceException.throwIf((boolean)stmtToBeAdded.equals(targetCtxSubstatement.getPublicDefinition()), (StatementSourceReference)stmtCtxToBeAdded.getStatementSourceReference(), (String)"Deviation cannot add substatement %s to target node %s because it is already defined in target and can appear only once.", (Object[])new Object[]{stmtToBeAdded.getStatementName(), targetCtx.getStatementArgument()});
            }
        }
        AbstractDeviateStatementSupport.copyStatement(stmtCtxToBeAdded, targetCtx);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void performDeviateReplace(StatementContextBase<?, ?, ?> deviateStmtCtx, StatementContextBase<?, ?, ?> targetCtx) {
        for (StmtContext.Mutable originalStmtCtx : deviateStmtCtx.mutableDeclaredSubstatements()) {
            AbstractDeviateStatementSupport.validateDeviationTarget(originalStmtCtx, targetCtx);
            AbstractDeviateStatementSupport.replaceStatement(originalStmtCtx, targetCtx);
        }
    }

    private static void replaceStatement(StmtContext.Mutable<?, ?, ?> stmtCtxToBeReplaced, StatementContextBase<?, ?, ?> targetCtx) {
        StatementDefinition stmtToBeReplaced = stmtCtxToBeReplaced.getPublicDefinition();
        if (YangStmtMapping.DEFAULT.equals((Object)stmtToBeReplaced) && YangStmtMapping.LEAF_LIST.equals((Object)targetCtx.getPublicDefinition())) {
            LOG.error("Deviation cannot replace substatement {} in target leaf-list {} because a leaf-list can have multiple default statements. At line: {}", new Object[]{stmtToBeReplaced.getStatementName(), targetCtx.getStatementArgument(), stmtCtxToBeReplaced.getStatementSourceReference()});
            return;
        }
        for (StmtContext targetCtxSubstatement : targetCtx.effectiveSubstatements()) {
            if (!stmtToBeReplaced.equals(targetCtxSubstatement.getPublicDefinition())) continue;
            targetCtx.removeStatementFromEffectiveSubstatements(stmtToBeReplaced);
            AbstractDeviateStatementSupport.copyStatement(stmtCtxToBeReplaced, targetCtx);
            return;
        }
        for (StmtContext targetCtxSubstatement : targetCtx.mutableDeclaredSubstatements()) {
            if (!stmtToBeReplaced.equals(targetCtxSubstatement.getPublicDefinition())) continue;
            targetCtxSubstatement.setIsSupportedToBuildEffective(false);
            AbstractDeviateStatementSupport.copyStatement(stmtCtxToBeReplaced, targetCtx);
            return;
        }
        if (IMPLICIT_STATEMENTS.contains((Object)stmtToBeReplaced)) {
            AbstractDeviateStatementSupport.addStatement(stmtCtxToBeReplaced, targetCtx);
            return;
        }
        throw new InferenceException(stmtCtxToBeReplaced.getStatementSourceReference(), "Deviation cannot replace substatement %s in target node %s because it does not exist in target node.", new Object[]{stmtToBeReplaced.getStatementName(), targetCtx.getStatementArgument()});
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void performDeviateDelete(StatementContextBase<?, ?, ?> deviateStmtCtx, StatementContextBase<?, ?, ?> targetCtx) {
        for (StmtContext.Mutable originalStmtCtx : deviateStmtCtx.mutableDeclaredSubstatements()) {
            AbstractDeviateStatementSupport.validateDeviationTarget(originalStmtCtx, targetCtx);
            AbstractDeviateStatementSupport.deleteStatement(originalStmtCtx, targetCtx);
        }
    }

    private static void deleteStatement(StmtContext<?, ?, ?> stmtCtxToBeDeleted, StatementContextBase<?, ?, ?> targetCtx) {
        StatementDefinition stmtToBeDeleted = stmtCtxToBeDeleted.getPublicDefinition();
        String stmtArgument = stmtCtxToBeDeleted.rawStatementArgument();
        for (StmtContext.Mutable targetCtxSubstatement : targetCtx.mutableEffectiveSubstatements()) {
            if (!AbstractDeviateStatementSupport.statementsAreEqual(stmtToBeDeleted, stmtArgument, targetCtxSubstatement.getPublicDefinition(), targetCtxSubstatement.rawStatementArgument())) continue;
            targetCtx.removeStatementFromEffectiveSubstatements(stmtToBeDeleted, stmtArgument);
            return;
        }
        for (StmtContext.Mutable targetCtxSubstatement : targetCtx.mutableDeclaredSubstatements()) {
            if (!AbstractDeviateStatementSupport.statementsAreEqual(stmtToBeDeleted, stmtArgument, targetCtxSubstatement.getPublicDefinition(), targetCtxSubstatement.rawStatementArgument())) continue;
            targetCtxSubstatement.setIsSupportedToBuildEffective(false);
            return;
        }
        LOG.error("Deviation cannot delete substatement {} with argument '{}' in target node {} because it does not exist in the target node. At line: {}", new Object[]{stmtToBeDeleted.getStatementName(), stmtArgument, targetCtx.getStatementArgument(), stmtCtxToBeDeleted.getStatementSourceReference()});
    }

    private static void copyStatement(StmtContext.Mutable<?, ?, ?> stmtCtxToBeCopied, StatementContextBase<?, ?, ?> targetCtx) {
        if (!StmtContextUtils.isUnknownStatement(stmtCtxToBeCopied)) {
            targetCtx.addEffectiveSubstatement(stmtCtxToBeCopied);
        } else {
            targetCtx.addEffectiveSubstatement(targetCtx.childCopyOf(stmtCtxToBeCopied, CopyType.ORIGINAL));
        }
    }

    private static boolean statementsAreEqual(StatementDefinition firstStmtDef, String firstStmtArg, StatementDefinition secondStmtDef, String secondStmtArg) {
        return firstStmtDef.equals(secondStmtDef) && Objects.equals(firstStmtArg, secondStmtArg);
    }

    private static void validateDeviationTarget(StmtContext<?, ?, ?> deviateSubStmtCtx, StmtContext<?, ?, ?> targetCtx) {
        InferenceException.throwIf((!AbstractDeviateStatementSupport.isSupportedDeviationTarget(deviateSubStmtCtx, targetCtx, targetCtx.getRootVersion()) ? 1 : 0) != 0, (StatementSourceReference)deviateSubStmtCtx.getStatementSourceReference(), (String)"%s is not a valid deviation target for substatement %s.", (Object[])new Object[]{targetCtx.getStatementArgument(), deviateSubStmtCtx.getPublicDefinition().getStatementName()});
    }

    private static boolean isSupportedDeviationTarget(StmtContext<?, ?, ?> deviateSubstatementCtx, StmtContext<?, ?, ?> deviateTargetCtx, YangVersion yangVersion) {
        Set supportedDeviationTargets = (Set)YangValidationBundles.SUPPORTED_DEVIATION_TARGETS.get((Object)deviateTargetCtx.getRootVersion(), (Object)deviateSubstatementCtx.getPublicDefinition());
        if (supportedDeviationTargets == null) {
            supportedDeviationTargets = (Set)YangValidationBundles.SUPPORTED_DEVIATION_TARGETS.get((Object)YangVersion.VERSION_1, (Object)deviateSubstatementCtx.getPublicDefinition());
        }
        return supportedDeviationTargets == null || supportedDeviationTargets.contains(deviateTargetCtx.getPublicDefinition());
    }
}

