/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YinElementEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;

final class ExtensionEffectiveStatementImpl
extends AbstractDeclaredEffectiveStatement.DefaultArgument<QName, ExtensionStatement>
implements ExtensionDefinition,
ExtensionEffectiveStatement,
EffectiveStatementMixins.DocumentedNodeMixin<QName, ExtensionStatement> {
    private static final RecursionDetector TOSTRING_DETECTOR = new RecursionDetector();
    private final @NonNull SchemaPath path;
    private volatile Object substatements;

    ExtensionEffectiveStatementImpl(ExtensionStatement declared, SchemaPath path) {
        super(declared);
        this.path = Objects.requireNonNull(path);
    }

    public QName getQName() {
        return (QName)this.argument();
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.path;
    }

    public String getArgument() {
        return this.findFirstEffectiveSubstatementArgument(ArgumentEffectiveStatement.class).map(AbstractQName::getLocalName).orElse(null);
    }

    public boolean isYinElement() {
        return this.findFirstEffectiveSubstatement(ArgumentEffectiveStatement.class).flatMap(arg -> arg.findFirstEffectiveSubstatementArgument(YinElementEffectiveStatement.class)).orElse(Boolean.FALSE);
    }

    public ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        Object local = Verify.verifyNotNull((Object)this.substatements, (String)"Substatements are not yet initialized", (Object[])new Object[0]);
        return ExtensionEffectiveStatementImpl.unmaskList(local);
    }

    public Status getStatus() {
        return this.findFirstEffectiveSubstatementArgument(StatusEffectiveStatement.class).orElse(Status.CURRENT);
    }

    public String toString() {
        if (TOSTRING_DETECTOR.check(this)) {
            return this.recursedToString();
        }
        TOSTRING_DETECTOR.push(this);
        try {
            String string = ExtensionEffectiveStatementImpl.class.getSimpleName() + "[argument=" + this.getArgument() + ", qname=" + this.getQName() + ", schemaPath=" + this.path + ", yin=" + this.isYinElement() + ", extensionSchemaNodes=" + this.getUnknownSchemaNodes() + "]";
            return string;
        }
        finally {
            TOSTRING_DETECTOR.pop();
        }
    }

    void setSubstatements(ImmutableList<? extends EffectiveStatement<?, ?>> newSubstatements) {
        Verify.verify((this.substatements == null ? 1 : 0) != 0, (String)"Substatements already initialized", (Object[])new Object[0]);
        this.substatements = ExtensionEffectiveStatementImpl.maskList(newSubstatements);
    }

    private String recursedToString() {
        return ExtensionEffectiveStatementImpl.class.getSimpleName() + "[argument=" + this.getArgument() + ", qname=" + this.getQName() + ", schemaPath=" + this.path + ", yin=" + this.isYinElement() + " <RECURSIVE> ]";
    }

    private static final class RecursionDetector
    extends ThreadLocal<Deque<ExtensionEffectiveStatementImpl>> {
        private RecursionDetector() {
        }

        boolean check(ExtensionEffectiveStatementImpl current) {
            Deque stack = (Deque)this.get();
            if (stack != null) {
                for (ExtensionEffectiveStatementImpl s : stack) {
                    if (s != current) continue;
                    return true;
                }
            }
            return false;
        }

        void push(ExtensionEffectiveStatementImpl current) {
            ArrayDeque<ExtensionEffectiveStatementImpl> stack = (ArrayDeque<ExtensionEffectiveStatementImpl>)this.get();
            if (stack == null) {
                stack = new ArrayDeque<ExtensionEffectiveStatementImpl>(1);
                this.set(stack);
            }
            stack.push(current);
        }

        void pop() {
            Deque stack = (Deque)this.get();
            stack.pop();
            if (stack.isEmpty()) {
                this.remove();
            }
        }
    }
}

