/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YinElementStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.EmptyExtensionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ExtensionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.RegularExtensionStatement;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementDefinitionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class ExtensionStatementSupport
extends BaseQNameStatementSupport<ExtensionStatement, ExtensionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.EXTENSION).addOptional((StatementDefinition)YangStmtMapping.ARGUMENT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();
    private static final ExtensionStatementSupport INSTANCE = new ExtensionStatementSupport();
    private static final ThreadLocal<Map<StmtContext<?, ?, ?>, ExtensionEffectiveStatementImpl>> TL_BUILDERS = new ThreadLocal();

    private ExtensionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.EXTENSION);
    }

    public static ExtensionStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementDefinitionDeclared(StmtContext.Mutable<QName, ExtensionStatement, ExtensionEffectiveStatement> stmt) {
        super.onStatementDefinitionDeclared(stmt);
        QName stmtName = (QName)stmt.coerceStatementArgument();
        if (OpenConfigStatements.OPENCONFIG_VERSION.getStatementName().isEqualWithoutRevision(stmtName)) {
            stmtName = stmtName.withoutRevision();
        }
        stmt.addContext(ExtensionNamespace.class, (Object)stmtName, stmt);
        StmtContext argument = StmtContextUtils.findFirstDeclaredSubstatement(stmt, ArgumentStatement.class);
        StmtContext yinElement = StmtContextUtils.findFirstDeclaredSubstatement(stmt, YinElementStatement.class);
        stmt.addToNs(StatementDefinitionNamespace.class, (Object)((QName)stmt.getStatementArgument()), (Object)new ModelDefinedStatementSupport(new ModelDefinedStatementDefinition((QName)stmt.getStatementArgument(), argument != null ? (QName)argument.getStatementArgument() : null, yinElement != null && (Boolean)yinElement.getStatementArgument() != false)));
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected ExtensionStatement createDeclared(StmtContext<QName, ExtensionStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularExtensionStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected ExtensionStatement createEmptyDeclared(StmtContext<QName, ExtensionStatement, ?> ctx) {
        return new EmptyExtensionStatement((QName)ctx.coerceStatementArgument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtensionEffectiveStatement createEffective(StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement> ctx) {
        ExtensionEffectiveStatementImpl existing;
        Map<StmtContext<?, ?, ?>, ExtensionEffectiveStatementImpl> tl = TL_BUILDERS.get();
        if (tl == null) {
            tl = new IdentityHashMap();
            TL_BUILDERS.set(tl);
        }
        if ((existing = tl.get(ctx)) != null) {
            return existing;
        }
        try {
            ExtensionEffectiveStatement extensionEffectiveStatement;
            ExtensionEffectiveStatementImpl created = new ExtensionEffectiveStatementImpl((ExtensionStatement)ctx.buildDeclared(), (SchemaPath)ctx.getSchemaPath().get());
            Verify.verify((tl.put(ctx, created) == null ? 1 : 0) != 0);
            try {
                extensionEffectiveStatement = super.createEffective(ctx);
                Verify.verify((tl.remove(ctx) == created ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Verify.verify((tl.remove(ctx) == created ? 1 : 0) != 0);
                throw throwable;
            }
            return extensionEffectiveStatement;
        }
        finally {
            if (tl.isEmpty()) {
                TL_BUILDERS.remove();
            }
        }
    }

    @Override
    protected ExtensionEffectiveStatement createEffective(StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement> ctx, ExtensionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return ExtensionStatementSupport.finishCreate(ctx, substatements);
    }

    @Override
    protected ExtensionEffectiveStatement createEmptyEffective(StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement> ctx, ExtensionStatement declared) {
        return ExtensionStatementSupport.finishCreate(ctx, ImmutableList.of());
    }

    private static @NonNull ExtensionEffectiveStatement finishCreate(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        ExtensionEffectiveStatementImpl ret = (ExtensionEffectiveStatementImpl)Verify.verifyNotNull((Object)((ExtensionEffectiveStatementImpl)((Map)Verify.verifyNotNull(TL_BUILDERS.get(), (String)"Statement build state not initialized", (Object[])new Object[0])).get(ctx)), (String)"No build state found for %s", (Object[])new Object[]{ctx});
        ret.setSubstatements(substatements);
        return ret;
    }
}

