/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnrecognizedEffectiveStatementImpl
extends UnknownEffectiveStatementBase<String, UnrecognizedStatement>
implements UnrecognizedEffectiveStatement {
    private static final Logger LOG = LoggerFactory.getLogger(UnrecognizedEffectiveStatementImpl.class);
    private final QName maybeQNameArgument;
    private final @NonNull SchemaPath path;

    UnrecognizedEffectiveStatementImpl(StmtContext<String, UnrecognizedStatement, ?> ctx) {
        super(ctx);
        SchemaPath maybePath;
        UnknownSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        if (original != null) {
            this.maybeQNameArgument = original.getQName();
        } else {
            QName maybeQNameArgumentInit = null;
            try {
                maybeQNameArgumentInit = StmtContextUtils.qnameFromArgument(ctx, (String)((String)this.argument()));
            }
            catch (SourceException e) {
                LOG.debug("Not constructing QName from {}", this.argument(), (Object)e);
                maybeQNameArgumentInit = this.getNodeType();
            }
            this.maybeQNameArgument = maybeQNameArgumentInit;
        }
        try {
            maybePath = ctx.coerceParentContext().getSchemaPath().map(parentPath -> parentPath.createChild(this.maybeQNameArgument)).orElse(null);
        }
        catch (IllegalArgumentException | SourceException e) {
            LOG.debug("Cannot construct path for {}, attempting to recover", ctx, (Object)e);
            maybePath = null;
        }
        this.path = maybePath;
    }

    public QName getQName() {
        return this.maybeQNameArgument;
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.path;
    }
}

