/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping.EmptyGroupingStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping.GroupingEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.grouping.RegularGroupingStatement;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractGroupingStatementSupport
extends BaseQNameStatementSupport<GroupingStatement, GroupingEffectiveStatement> {
    AbstractGroupingStatementSupport() {
        super((StatementDefinition)YangStmtMapping.GROUPING);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<QName, GroupingStatement, GroupingEffectiveStatement> stmt) {
        StmtContext.Mutable parent;
        super.onFullDefinitionDeclared(stmt);
        if (stmt != null && (parent = stmt.getParentContext()) != null) {
            AbstractGroupingStatementSupport.checkConflict(parent, stmt);
            parent.addContext(GroupingNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
        }
    }

    @Override
    protected final GroupingStatement createDeclared(StmtContext<QName, GroupingStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        AbstractGroupingStatementSupport.checkDeclaredConflict(ctx);
        return new RegularGroupingStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final GroupingStatement createEmptyDeclared(StmtContext<QName, GroupingStatement, ?> ctx) {
        AbstractGroupingStatementSupport.checkDeclaredConflict(ctx);
        return new EmptyGroupingStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final GroupingEffectiveStatement createEffective(StmtContext<QName, GroupingStatement, GroupingEffectiveStatement> ctx, GroupingStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new GroupingEffectiveStatementImpl(declared, ctx, substatements, AbstractGroupingStatementSupport.historyAndStatusFlags(ctx, substatements));
    }

    @Override
    protected GroupingEffectiveStatement createEmptyEffective(StmtContext<QName, GroupingStatement, GroupingEffectiveStatement> ctx, GroupingStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    private static void checkDeclaredConflict(StmtContext<QName, ?, ?> ctx) {
        StmtContext grandParent;
        StmtContext parent = ctx.getParentContext();
        if (parent != null && (grandParent = parent.getParentContext()) != null) {
            AbstractGroupingStatementSupport.checkConflict(grandParent, ctx);
        }
    }

    private static void checkConflict(StmtContext<?, ?, ?> parent, StmtContext<QName, ?, ?> stmt) {
        QName arg = (QName)stmt.coerceStatementArgument();
        StmtContext existing = (StmtContext)parent.getFromNamespace(GroupingNamespace.class, (Object)arg);
        SourceException.throwIf((existing != null ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Duplicate name for grouping %s", (Object[])new Object[]{arg});
    }
}

