/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateEffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.RevisionImport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.SemanticVersionImport;
import org.opendaylight.yangtools.yang.parser.spi.PreLinkageModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToSemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractImportStatementSupport
extends BaseStringStatementSupport<ImportStatement, ImportEffectiveStatement> {
    AbstractImportStatementSupport() {
        super((StatementDefinition)YangStmtMapping.IMPORT);
    }

    public final void onPreLinkageDeclared(final StmtContext.Mutable<String, ImportStatement, ImportEffectiveStatement> stmt) {
        stmt.addRequiredSource(RevisionImport.getImportedSourceIdentifier(stmt));
        final String moduleName = (String)stmt.coerceStatementArgument();
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        final ModelActionBuilder.Prerequisite imported = importAction.requiresCtx(stmt, PreLinkageModuleNamespace.class, (Object)moduleName, ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        importAction.mutatesCtx(stmt.getRoot(), ModelProcessingPhase.SOURCE_PRE_LINKAGE);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext importedModuleContext = (StmtContext)imported.resolve(ctx);
                Verify.verify((boolean)moduleName.equals(importedModuleContext.getStatementArgument()));
                URI importedModuleNamespace = (URI)importedModuleContext.getFromNamespace(ModuleNameToNamespace.class, (Object)moduleName);
                Verify.verifyNotNull((Object)importedModuleNamespace);
                String impPrefix = (String)SourceException.throwIfNull((Object)((String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class)), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Missing prefix statement", (Object[])new Object[0]);
                stmt.addToNs(ImpPrefixToNamespace.class, (Object)impPrefix, (Object)importedModuleNamespace);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(imported), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Imported module [%s] was not found.", (Object[])new Object[]{moduleName});
            }
        });
    }

    public final void onLinkageDeclared(StmtContext.Mutable<String, ImportStatement, ImportEffectiveStatement> stmt) {
        if (stmt.isEnabledSemanticVersioning()) {
            SemanticVersionImport.onLinkageDeclared(stmt);
        } else {
            RevisionImport.onLinkageDeclared(stmt);
        }
    }

    @Override
    protected final ImportStatement createDeclared(StmtContext<String, ImportStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new ImportStatementImpl(ctx, substatements);
    }

    @Override
    protected final ImportStatement createEmptyDeclared(StmtContext<String, ImportStatement, ?> ctx) {
        throw new IllegalStateException("Unexpected empty declared import statement");
    }

    @Override
    protected final ImportEffectiveStatement createEffective(StmtContext<String, ImportStatement, ImportEffectiveStatement> ctx, ImportStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        SemVer semVer;
        Revision revision;
        String prefix = declared.getPrefix().getValue();
        if (!ctx.isEnabledSemanticVersioning()) {
            Optional<Revision> optRev = substatements.stream().filter(RevisionDateEffectiveStatement.class::isInstance).findFirst().map(stmt -> (Revision)((RevisionDateEffectiveStatement)stmt).argument());
            revision = optRev.isPresent() ? optRev.get() : AbstractImportStatementSupport.getImportedRevision(ctx, declared.getModule(), prefix);
            semVer = null;
        } else {
            SemVerSourceIdentifier importedModuleIdentifier = (SemVerSourceIdentifier)ctx.getFromNamespace(ImportPrefixToSemVerSourceIdentifier.class, (Object)prefix);
            revision = importedModuleIdentifier.getRevision().orElse(null);
            semVer = importedModuleIdentifier.getSemanticVersion().orElse(null);
        }
        return new ImportEffectiveStatementImpl(declared, substatements, revision, semVer);
    }

    @Override
    protected final ImportEffectiveStatement createEmptyEffective(StmtContext<String, ImportStatement, ImportEffectiveStatement> ctx, ImportStatement declared) {
        throw new IllegalStateException("Unexpected empty effective import statement");
    }

    private static Revision getImportedRevision(StmtContext<String, ImportStatement, ?> ctx, String moduleName, String prefix) {
        QNameModule importedModule = StmtContextUtils.getModuleQNameByPrefix(ctx, (String)prefix);
        SourceException.throwIfNull((Object)importedModule, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to find import of module %s with prefix %s.", (Object[])new Object[]{moduleName, prefix});
        return importedModule.getRevision().orElse(null);
    }
}

