/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include.EmptyIncludeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include.EmptyIncludeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include.RegularIncludeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.include.RegularIncludeStatement;
import org.opendaylight.yangtools.yang.parser.spi.SubmoduleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractIncludeStatementSupport
extends BaseStringStatementSupport<IncludeStatement, IncludeEffectiveStatement> {
    AbstractIncludeStatementSupport() {
        super((StatementDefinition)YangStmtMapping.INCLUDE);
    }

    public final void onPreLinkageDeclared(StmtContext.Mutable<String, IncludeStatement, IncludeEffectiveStatement> stmt) {
        StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        stmt.addRequiredSource((SourceIdentifier)(revision == null ? RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument())) : RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument()), (Revision)((Revision)revision.getStatementArgument()))));
    }

    public final void onLinkageDeclared(final StmtContext.Mutable<String, IncludeStatement, IncludeEffectiveStatement> stmt) {
        final String submoduleName = (String)stmt.coerceStatementArgument();
        final StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        ModelActionBuilder includeAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite requiresCtxPrerequisite = revision == null ? includeAction.requiresCtx(stmt, SubmoduleNamespace.class, NamespaceKeyCriterion.latestRevisionModule((String)submoduleName), ModelProcessingPhase.SOURCE_LINKAGE) : includeAction.requiresCtx(stmt, SubmoduleNamespace.class, (Object)RevisionSourceIdentifier.create((String)submoduleName, Optional.of((Revision)revision.getStatementArgument())), ModelProcessingPhase.SOURCE_LINKAGE);
        includeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext includedSubModuleContext = (StmtContext)requiresCtxPrerequisite.resolve(ctx);
                stmt.addToNs(IncludedModuleContext.class, (Object)(revision != null ? RevisionSourceIdentifier.create((String)submoduleName, (Revision)((Revision)revision.getStatementArgument())) : RevisionSourceIdentifier.create((String)submoduleName)), (Object)includedSubModuleContext);
                stmt.addToNs(IncludedSubmoduleNameToModuleCtx.class, (Object)((String)stmt.getStatementArgument()), (Object)includedSubModuleContext);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(requiresCtxPrerequisite), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Included submodule '%s' was not found: ", (Object[])new Object[]{stmt.getStatementArgument()});
            }
        });
    }

    @Override
    protected final IncludeStatement createDeclared(StmtContext<String, IncludeStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularIncludeStatement(ctx, substatements);
    }

    @Override
    protected final IncludeStatement createEmptyDeclared(StmtContext<String, IncludeStatement, ?> ctx) {
        return new EmptyIncludeStatement(ctx);
    }

    @Override
    protected final IncludeEffectiveStatement createEffective(StmtContext<String, IncludeStatement, IncludeEffectiveStatement> ctx, IncludeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularIncludeEffectiveStatement(declared, substatements);
    }

    @Override
    protected final IncludeEffectiveStatement createEmptyEffective(StmtContext<String, IncludeStatement, IncludeEffectiveStatement> ctx, IncludeStatement declared) {
        return new EmptyIncludeEffectiveStatement(declared);
    }
}

