/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseOperationContainerStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.DeclaredInputEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.EmptyInputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.EmptyUndeclaredInputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.RegularInputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.RegularUndeclaredInputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.UndeclaredInputEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

abstract class AbstractInputStatementSupport
extends BaseOperationContainerStatementSupport<InputStatement, InputEffectiveStatement> {
    AbstractInputStatementSupport() {
        super((StatementDefinition)YangStmtMapping.INPUT);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return YangConstants.operationInputQName((QNameModule)StmtContextUtils.getRootModuleQName(ctx));
    }

    @Override
    protected final InputStatement createDeclared(StmtContext<QName, InputStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return new RegularUndeclaredInputStatement((QName)ctx.coerceStatementArgument(), substatements);
            }
            case DECLARATION: {
                return new RegularInputStatement((QName)ctx.coerceStatementArgument(), substatements);
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final InputStatement createEmptyDeclared(StmtContext<QName, InputStatement, ?> ctx) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return new EmptyUndeclaredInputStatement((QName)ctx.coerceStatementArgument());
            }
            case DECLARATION: {
                return new EmptyInputStatement((QName)ctx.coerceStatementArgument());
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final InputEffectiveStatement createDeclaredEffective(int flags, StmtContext<QName, InputStatement, InputEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, InputStatement declared) {
        return new DeclaredInputEffectiveStatement(declared, flags, ctx, substatements);
    }

    @Override
    protected final InputEffectiveStatement createUndeclaredEffective(int flags, StmtContext<QName, InputStatement, InputEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new UndeclaredInputEffectiveStatement(flags, ctx, substatements);
    }
}

