/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.EmptyForeignKeyEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.EmptyKeyStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.EmptyLocalKeyEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.RegularForeignKeyEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.RegularKeyStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.key.RegularLocalKeyEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class KeyStatementSupport
extends BaseStatementSupport<Set<QName>, KeyStatement, KeyEffectiveStatement> {
    private static final Splitter LIST_KEY_SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.KEY).build();
    private static final KeyStatementSupport INSTANCE = new KeyStatementSupport();

    private KeyStatementSupport() {
        super((StatementDefinition)YangStmtMapping.KEY);
    }

    public static KeyStatementSupport getInstance() {
        return INSTANCE;
    }

    public ImmutableSet<QName> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int tokens = 0;
        for (String keyToken : LIST_KEY_SPLITTER.split((CharSequence)value)) {
            builder.add((Object)StmtContextUtils.parseNodeIdentifier(ctx, (String)keyToken));
            ++tokens;
        }
        ImmutableSet ret = builder.build();
        SourceException.throwIf((ret.size() != tokens ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Key argument '%s' contains duplicates", (Object[])new Object[]{value});
        return ret;
    }

    public Set<QName> adaptArgumentValue(StmtContext<Set<QName>, KeyStatement, KeyEffectiveStatement> ctx, QNameModule targetModule) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        boolean replaced = false;
        for (QName qname : (Set)ctx.coerceStatementArgument()) {
            if (!targetModule.equals((Object)qname.getModule())) {
                QName newQname = qname.bindTo(targetModule).intern();
                builder.add((Object)newQname);
                replaced = true;
                continue;
            }
            builder.add((Object)qname);
        }
        return replaced ? builder.build() : (Set)ctx.getStatementArgument();
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected KeyStatement createDeclared(StmtContext<Set<QName>, KeyStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularKeyStatement(ctx, substatements);
    }

    @Override
    protected KeyStatement createEmptyDeclared(StmtContext<Set<QName>, KeyStatement, ?> ctx) {
        return new EmptyKeyStatement(ctx);
    }

    @Override
    protected KeyEffectiveStatement createEffective(StmtContext<Set<QName>, KeyStatement, KeyEffectiveStatement> ctx, KeyStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        Set arg = (Set)ctx.coerceStatementArgument();
        return arg.equals(declared.argument()) ? new RegularLocalKeyEffectiveStatement(declared, substatements) : new RegularForeignKeyEffectiveStatement(declared, arg, substatements);
    }

    @Override
    protected KeyEffectiveStatement createEmptyEffective(StmtContext<Set<QName>, KeyStatement, KeyEffectiveStatement> ctx, KeyStatement declared) {
        Set arg = (Set)ctx.coerceStatementArgument();
        return arg.equals(declared.argument()) ? new EmptyLocalKeyEffectiveStatement(declared) : new EmptyForeignKeyEffectiveStatement(declared, arg);
    }

    static @NonNull Object maskSet(@NonNull Set<QName> set) {
        return set.size() == 1 ? set.iterator().next() : set;
    }

    static @NonNull Set<QName> unmaskSet(@NonNull Object masked) {
        if (masked instanceof Set) {
            return (Set)masked;
        }
        Verify.verify((boolean)(masked instanceof QName), (String)"Unexpected argument %s", (Object)masked);
        return ImmutableSet.of((Object)((QName)masked));
    }
}

