/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;

abstract class AbstractLeafListEffectiveStatement
extends AbstractDeclaredEffectiveStatement.Default<QName, LeafListStatement>
implements LeafListEffectiveStatement,
LeafListSchemaNode,
DerivableSchemaNode,
EffectiveStatementMixins.UserOrderedMixin<QName, LeafListStatement>,
EffectiveStatementMixins.DataSchemaNodeMixin<QName, LeafListStatement>,
EffectiveStatementMixins.MustConstraintMixin<QName, LeafListStatement> {
    private final @NonNull Object substatements;
    private final @NonNull SchemaPath path;
    private final @NonNull TypeDefinition<?> type;
    private final int flags;

    AbstractLeafListEffectiveStatement(LeafListStatement declared, SchemaPath path, int flags, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        super(declared);
        this.substatements = AbstractLeafListEffectiveStatement.maskList(substatements);
        this.path = Objects.requireNonNull(path);
        this.flags = flags;
        this.type = this.buildType();
    }

    public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return AbstractLeafListEffectiveStatement.unmaskList(this.substatements);
    }

    @Override
    public final int flags() {
        return this.flags;
    }

    public final @NonNull QName argument() {
        return this.getQName();
    }

    @Deprecated
    public final SchemaPath getPath() {
        return this.path;
    }

    public final TypeDefinition<?> getType() {
        return this.type;
    }

    public final boolean isUserOrdered() {
        return this.userOrdered();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQName() + "]";
    }

    private TypeDefinition<?> buildType() {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)this.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).get();
        ConcreteTypeBuilder builder = ConcreteTypes.concreteTypeBuilder((TypeDefinition)typeStmt.getTypeDefinition(), (SchemaPath)this.getPath());
        for (EffectiveStatement stmt : this.effectiveSubstatements()) {
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (!(stmt instanceof UnitsEffectiveStatement)) continue;
            builder.setUnits((String)((UnitsEffectiveStatement)stmt).argument());
        }
        return builder.build();
    }
}

