/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list.EmptyLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list.EmptyLeafListStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list.RegularLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list.RegularLeafListStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.leaf_list.SlimLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractLeafListStatementSupport
extends BaseQNameStatementSupport<LeafListStatement, LeafListEffectiveStatement> {
    AbstractLeafListStatementSupport() {
        super((StatementDefinition)YangStmtMapping.LEAF_LIST);
    }

    public final void onStatementAdded(StmtContext.Mutable<QName, LeafListStatement, LeafListEffectiveStatement> stmt) {
        stmt.coerceParentContext().addToNs(ChildSchemaNodeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    @Override
    protected final LeafListStatement createDeclared(StmtContext<QName, LeafListStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularLeafListStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final LeafListStatement createEmptyDeclared(StmtContext<QName, LeafListStatement, ?> ctx) {
        return new EmptyLeafListStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final LeafListEffectiveStatement createEffective(StmtContext<QName, LeafListStatement, LeafListEffectiveStatement> ctx, LeafListStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)AbstractLeafListStatementSupport.findFirstStatement(substatements, TypeEffectiveStatement.class), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf-list is missing a 'type' statement", (Object[])new Object[0]);
        SchemaPath path = (SchemaPath)ctx.getSchemaPath().get();
        LeafListSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AbstractLeafListStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration()).setUserOrdered(AbstractLeafListStatementSupport.findFirstArgument(substatements, OrderedByEffectiveStatement.class, OrderedByStatement.Ordering.SYSTEM).equals((Object)OrderedByStatement.Ordering.USER)).toFlags();
        ImmutableSet defaultValues = (ImmutableSet)substatements.stream().filter(DefaultEffectiveStatement.class::isInstance).map(DefaultEffectiveStatement.class::cast).map(ModelStatement::argument).collect(ImmutableSet.toImmutableSet());
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(ctx.getRootVersion(), typeStmt, (Set<String>)defaultValues), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Leaf-list '%s' has one of its default values '%s' marked with an if-feature statement.", (Object[])new Object[]{ctx.getStatementArgument(), defaultValues});
        Optional<ElementCountConstraint> elementCountConstraint = EffectiveStmtUtils.createElementCountConstraint(substatements);
        if (defaultValues.isEmpty()) {
            return original == null && !elementCountConstraint.isPresent() ? new EmptyLeafListEffectiveStatement(declared, path, flags, substatements) : new SlimLeafListEffectiveStatement(declared, path, flags, substatements, original, elementCountConstraint.orElse(null));
        }
        return new RegularLeafListEffectiveStatement(declared, path, flags, substatements, original, (ImmutableSet<String>)defaultValues, elementCountConstraint.orElse(null));
    }

    @Override
    protected final LeafListEffectiveStatement createEmptyEffective(StmtContext<QName, LeafListStatement, LeafListEffectiveStatement> ctx, LeafListStatement declared) {
        throw new UnsupportedOperationException("Leaf statements must have at least one substatement");
    }
}

