/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.modifier;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierStatement;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.modifier.EmptyModifierEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.modifier.EmptyModifierStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.modifier.RegularModifierEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.modifier.RegularModifierStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class ModifierStatementSupport
extends BaseStatementSupport<ModifierKind, ModifierStatement, ModifierEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MODIFIER).build();
    private static final ModifierStatementSupport INSTANCE = new ModifierStatementSupport();

    private ModifierStatementSupport() {
        super((StatementDefinition)YangStmtMapping.MODIFIER);
    }

    public static ModifierStatementSupport getInstance() {
        return INSTANCE;
    }

    public ModifierKind parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (ModifierKind)SourceException.unwrap((Optional)ModifierKind.parse((String)value), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"'%s' is not valid argument of modifier statement", (Object[])new Object[]{value});
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    public String internArgument(String rawArgument) {
        return "invert-match".equals(rawArgument) ? "invert-match" : rawArgument;
    }

    @Override
    protected ModifierStatement createDeclared(StmtContext<ModifierKind, ModifierStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularModifierStatement(ctx, substatements);
    }

    @Override
    protected ModifierStatement createEmptyDeclared(StmtContext<ModifierKind, ModifierStatement, ?> ctx) {
        return new EmptyModifierStatement(ctx);
    }

    @Override
    protected ModifierEffectiveStatement createEffective(StmtContext<ModifierKind, ModifierStatement, ModifierEffectiveStatement> ctx, ModifierStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularModifierEffectiveStatement(declared, substatements);
    }

    @Override
    protected ModifierEffectiveStatement createEmptyEffective(StmtContext<ModifierKind, ModifierStatement, ModifierEffectiveStatement> ctx, ModifierStatement declared) {
        return new EmptyModifierEffectiveStatement(declared);
    }
}

