/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PathEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.EmptyPathEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.EmptyPathStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.PathExpressionParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.RegularPathEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.RegularPathStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class PathStatementSupport
extends BaseStatementSupport<PathExpression, PathStatement, PathEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.PATH).build();
    private static final PathStatementSupport LENIENT_INSTANCE = new PathStatementSupport(new PathExpressionParser.Lenient());
    private static final PathStatementSupport STRICT_INSTANCE = new PathStatementSupport(new PathExpressionParser());
    private final PathExpressionParser parser;

    private PathStatementSupport(PathExpressionParser parser) {
        super((StatementDefinition)YangStmtMapping.PATH);
        this.parser = Objects.requireNonNull(parser);
    }

    public static PathStatementSupport lenientInstance() {
        return LENIENT_INSTANCE;
    }

    public static PathStatementSupport strictInstance() {
        return STRICT_INSTANCE;
    }

    public PathExpression parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return this.parser.parseExpression(ctx, value);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected PathStatement createDeclared(StmtContext<PathExpression, PathStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularPathStatement((PathExpression)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected PathStatement createEmptyDeclared(StmtContext<PathExpression, PathStatement, ?> ctx) {
        return new EmptyPathStatement((PathExpression)ctx.coerceStatementArgument());
    }

    @Override
    protected PathEffectiveStatement createEffective(StmtContext<PathExpression, PathStatement, PathEffectiveStatement> ctx, PathStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularPathEffectiveStatement(declared, substatements);
    }

    @Override
    protected PathEffectiveStatement createEmptyEffective(StmtContext<PathExpression, PathStatement, PathEffectiveStatement> ctx, PathStatement declared) {
        return new EmptyPathEffectiveStatement(declared);
    }
}

