/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.util.AbstractPathExpression;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;

final class UnparsedPathExpression
extends AbstractPathExpression {
    private final RuntimeException cause;
    private final boolean absolute;

    UnparsedPathExpression(String originalString, RuntimeException cause) {
        super(originalString);
        this.cause = Objects.requireNonNull(cause);
        this.absolute = ArgumentUtils.isAbsoluteXPath(originalString);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public PathExpression.Steps getSteps() {
        throw new UnsupportedOperationException("Expression '" + this.getOriginalString() + "' was not parsed", this.cause);
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper.add("absolute", this.absolute)).add("cause", (Object)this.cause);
    }
}

