/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;

abstract class AbstractPatternConstraint
implements PatternConstraint,
Immutable {
    private final String regEx;
    private final String rawRegEx;
    private final String errorAppTag;

    AbstractPatternConstraint(String regex, String rawRegex, String errorAppTag) {
        this.regEx = Objects.requireNonNull(regex, "regex must not be null");
        this.rawRegEx = Objects.requireNonNull(rawRegex, "raw regex must not be null");
        this.errorAppTag = errorAppTag != null ? errorAppTag : "invalid-regular-expression";
    }

    public final String getJavaPatternString() {
        return this.regEx;
    }

    public final String getRegularExpressionString() {
        return this.rawRegEx;
    }

    public final Optional<String> getDescription() {
        return Optional.ofNullable(this.description());
    }

    public final Optional<String> getErrorAppTag() {
        return Optional.of(this.errorAppTag);
    }

    public final Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage());
    }

    public final Optional<ModifierKind> getModifier() {
        return Optional.ofNullable(this.modifier());
    }

    public final Optional<String> getReference() {
        return Optional.ofNullable(this.reference());
    }

    public final int hashCode() {
        return Objects.hash(this.description(), this.errorAppTag, this.errorMessage(), this.reference(), this.regEx, this.modifier());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPatternConstraint)) {
            return false;
        }
        AbstractPatternConstraint other = (AbstractPatternConstraint)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.errorAppTag, other.errorAppTag) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.regEx, other.regEx) && Objects.equals(this.modifier(), other.modifier());
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    abstract @Nullable String description();

    abstract @Nullable String reference();

    abstract @Nullable String errorMessage();

    abstract @Nullable ModifierKind modifier();

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("regex", (Object)this.regEx).add("errorAppTag", (Object)this.errorAppTag);
    }
}

