/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorAppTagEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorMessageEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.util.RegexUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.EmptyPatternConstraint;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.EmptyPatternEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.EmptyPatternStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.RegularPatternConstraint;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.RegularPatternEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.RegularPatternStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.SimplePatternEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPatternStatementSupport
extends BaseStatementSupport<PatternConstraint, PatternStatement, PatternEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPatternStatementSupport.class);

    AbstractPatternStatementSupport() {
        super((StatementDefinition)YangStmtMapping.PATTERN, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public final PatternConstraint parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        String pattern = RegexUtils.getJavaRegexFromXSD((String)value);
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            LOG.debug("Pattern \"{}\" failed to compile at {}", new Object[]{pattern, ctx.getStatementSourceReference(), e});
            return null;
        }
        return new EmptyPatternConstraint(pattern, value);
    }

    @Override
    protected final PatternStatement createDeclared(StmtContext<PatternConstraint, PatternStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularPatternStatement(ctx, substatements);
    }

    @Override
    protected final PatternStatement createEmptyDeclared(StmtContext<PatternConstraint, PatternStatement, ?> ctx) {
        return new EmptyPatternStatement(ctx);
    }

    @Override
    protected final PatternEffectiveStatement createEffective(StmtContext<PatternConstraint, PatternStatement, PatternEffectiveStatement> ctx, PatternStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        String description = AbstractPatternStatementSupport.findFirstArgument(substatements, DescriptionEffectiveStatement.class, null);
        String reference = AbstractPatternStatementSupport.findFirstArgument(substatements, ReferenceEffectiveStatement.class, null);
        String errorAppTag = AbstractPatternStatementSupport.findFirstArgument(substatements, ErrorAppTagEffectiveStatement.class, null);
        String errorMessage = AbstractPatternStatementSupport.findFirstArgument(substatements, ErrorMessageEffectiveStatement.class, null);
        ModifierKind modifier = AbstractPatternStatementSupport.findFirstArgument(substatements, ModifierEffectiveStatement.class, null);
        if (description == null && reference == null && errorAppTag == null && errorMessage == null && modifier == null) {
            return new SimplePatternEffectiveStatement(declared, substatements);
        }
        return new RegularPatternEffectiveStatement(declared, new RegularPatternConstraint((PatternConstraint)declared.argument(), description, reference, errorAppTag, errorMessage, modifier), substatements);
    }

    @Override
    protected final PatternEffectiveStatement createEmptyEffective(StmtContext<PatternConstraint, PatternStatement, PatternEffectiveStatement> ctx, PatternStatement declared) {
        return new EmptyPatternEffectiveStatement(declared);
    }
}

