/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseInternedStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position.EmptyPositionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position.EmptyPositionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position.RegularPositionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.position.RegularPositionStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class PositionStatementSupport
extends BaseInternedStatementSupport<Uint32, PositionStatement, PositionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.POSITION).build();
    private static final PositionStatementSupport INSTANCE = new PositionStatementSupport();

    private PositionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.POSITION);
    }

    public static PositionStatementSupport getInstance() {
        return INSTANCE;
    }

    public Uint32 parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Uint32.valueOf((String)value).intern();
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(String.format("Bit position value %s is not valid integer", value), ctx.getStatementSourceReference(), (Throwable)e);
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected PositionStatement createDeclared(Uint32 argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularPositionStatement(argument, substatements);
    }

    @Override
    protected PositionStatement createEmptyDeclared(Uint32 argument) {
        return new EmptyPositionStatement(argument);
    }

    @Override
    protected PositionEffectiveStatement createEmptyEffective(PositionStatement declared) {
        return new EmptyPositionEffectiveStatement(declared);
    }

    @Override
    protected PositionEffectiveStatement createEffective(StmtContext<Uint32, PositionStatement, PositionEffectiveStatement> ctx, PositionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularPositionEffectiveStatement(declared, substatements);
    }
}

