/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date;

import com.google.common.collect.ImmutableList;
import java.time.format.DateTimeParseException;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date.EmptyRevisionDateEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date.EmptyRevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date.RegularRevisionDateEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision_date.RegularRevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class RevisionDateStatementSupport
extends BaseStatementSupport<Revision, RevisionDateStatement, RevisionDateEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REVISION_DATE).build();
    private static final RevisionDateStatementSupport INSTANCE = new RevisionDateStatementSupport();

    private RevisionDateStatementSupport() {
        super((StatementDefinition)YangStmtMapping.REVISION_DATE, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static RevisionDateStatementSupport getInstance() {
        return INSTANCE;
    }

    public Revision parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Revision.of((String)value);
        }
        catch (DateTimeParseException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Revision value %s is not in required format yyyy-MM-dd", new Object[]{value});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected RevisionDateStatement createDeclared(StmtContext<Revision, RevisionDateStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularRevisionDateStatement((Revision)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected RevisionDateStatement createEmptyDeclared(StmtContext<Revision, RevisionDateStatement, ?> ctx) {
        return new EmptyRevisionDateStatement((Revision)ctx.coerceStatementArgument());
    }

    @Override
    protected RevisionDateEffectiveStatement createEffective(StmtContext<Revision, RevisionDateStatement, RevisionDateEffectiveStatement> ctx, RevisionDateStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularRevisionDateEffectiveStatement(declared, substatements);
    }

    @Override
    protected RevisionDateEffectiveStatement createEmptyEffective(StmtContext<Revision, RevisionDateStatement, RevisionDateEffectiveStatement> ctx, RevisionDateStatement declared) {
        return new EmptyRevisionDateEffectiveStatement(declared);
    }
}

