/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractIdentityRefSpecificationSupport
extends BaseStatementSupport<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> {
    AbstractIdentityRefSpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        Collection baseStatements = StmtContextUtils.findAllDeclaredSubstatements(stmt, BaseStatement.class);
        for (StmtContext baseStmt : baseStatements) {
            QName baseIdentity = (QName)baseStmt.coerceStatementArgument();
            StmtContext stmtCtx = (StmtContext)stmt.getFromNamespace(IdentityNamespace.class, (Object)baseIdentity);
            InferenceException.throwIfNull((Object)stmtCtx, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Referenced base identity '%s' doesn't exist in given scope (module, imported modules, submodules)", (Object[])new Object[]{baseIdentity.getLocalName()});
        }
    }

    @Override
    protected final TypeStatement.IdentityRefSpecification createDeclared(StmtContext<String, TypeStatement.IdentityRefSpecification, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new IdentityRefSpecificationImpl(ctx, substatements);
    }

    @Override
    protected final TypeStatement.IdentityRefSpecification createEmptyDeclared(StmtContext<String, TypeStatement.IdentityRefSpecification, ?> ctx) {
        throw AbstractIdentityRefSpecificationSupport.noBase(ctx);
    }

    @Override
    protected final EffectiveStatement<String, TypeStatement.IdentityRefSpecification> createEffective(StmtContext<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> ctx, TypeStatement.IdentityRefSpecification declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        IdentityrefTypeBuilder builder = BaseTypes.identityrefTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof BaseEffectiveStatement)) continue;
            QName identityQName = (QName)((BaseEffectiveStatement)stmt).argument();
            StmtContext identityCtx = (StmtContext)ctx.getFromNamespace(IdentityNamespace.class, (Object)identityQName);
            builder.addIdentity((IdentitySchemaNode)identityCtx.buildEffective());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    @Override
    protected final EffectiveStatement<String, TypeStatement.IdentityRefSpecification> createEmptyEffective(StmtContext<String, TypeStatement.IdentityRefSpecification, EffectiveStatement<String, TypeStatement.IdentityRefSpecification>> ctx, TypeStatement.IdentityRefSpecification declared) {
        throw AbstractIdentityRefSpecificationSupport.noBase(ctx);
    }

    private static SourceException noBase(StmtContext<?, ?, ?> ctx) {
        return new SourceException("At least one base statement has to be present", ctx.getStatementSourceReference());
    }
}

