/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.InstanceIdentifierTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.InvalidLengthConstraintException;
import org.opendaylight.yangtools.yang.model.util.type.InvalidRangeConstraintException;
import org.opendaylight.yangtools.yang.model.util.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RequireInstanceRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.model.util.type.StringTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinTypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.Decimal64SpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EmptyTypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationRFC6020Support;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.InstanceIdentifierSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefSpecificationRFC6020Support;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RegularTypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.spi.TypeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTypeStatementSupport
extends BaseStatementSupport<String, TypeStatement, EffectiveStatement<String, TypeStatement>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTypeStatementSupport.class);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.BASE).addAny((StatementDefinition)YangStmtMapping.BIT).addAny((StatementDefinition)YangStmtMapping.ENUM).addOptional((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).addOptional((StatementDefinition)YangStmtMapping.LENGTH).addOptional((StatementDefinition)YangStmtMapping.PATH).addAny((StatementDefinition)YangStmtMapping.PATTERN).addOptional((StatementDefinition)YangStmtMapping.RANGE).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).addAny((StatementDefinition)YangStmtMapping.TYPE).build();
    static final String BINARY = "binary";
    static final String BITS = "bits";
    static final String BOOLEAN = "boolean";
    static final String DECIMAL64 = "decimal64";
    static final String EMPTY = "empty";
    static final String ENUMERATION = "enumeration";
    static final String IDENTITY_REF = "identityref";
    static final String INSTANCE_IDENTIFIER = "instance-identifier";
    static final String INT8 = "int8";
    static final String INT16 = "int16";
    static final String INT32 = "int32";
    static final String INT64 = "int64";
    static final String LEAF_REF = "leafref";
    static final String STRING = "string";
    static final String UINT8 = "uint8";
    static final String UINT16 = "uint16";
    static final String UINT32 = "uint32";
    static final String UINT64 = "uint64";
    static final String UNION = "union";
    private static final ImmutableMap<String, String> BUILT_IN_TYPES = ImmutableMap.builder().put((Object)"binary", (Object)"binary").put((Object)"bits", (Object)"bits").put((Object)"boolean", (Object)"boolean").put((Object)"decimal64", (Object)"decimal64").put((Object)"empty", (Object)"empty").put((Object)"enumeration", (Object)"enumeration").put((Object)"identityref", (Object)"identityref").put((Object)"instance-identifier", (Object)"instance-identifier").put((Object)"int8", (Object)"int8").put((Object)"int16", (Object)"int16").put((Object)"int32", (Object)"int32").put((Object)"int64", (Object)"int64").put((Object)"leafref", (Object)"leafref").put((Object)"string", (Object)"string").put((Object)"uint8", (Object)"uint8").put((Object)"uint16", (Object)"uint16").put((Object)"uint32", (Object)"uint32").put((Object)"uint64", (Object)"uint64").put((Object)"union", (Object)"union").build();
    private static final ImmutableMap<String, StatementSupport<?, ?, ?>> ARGUMENT_SPECIFIC_SUPPORTS = ImmutableMap.builder().put((Object)"bits", (Object)new BitsSpecificationSupport()).put((Object)"decimal64", (Object)new Decimal64SpecificationSupport()).put((Object)"enumeration", (Object)new EnumSpecificationSupport()).put((Object)"identityref", (Object)new IdentityRefSpecificationRFC6020Support()).put((Object)"instance-identifier", (Object)new InstanceIdentifierSpecificationSupport()).put((Object)"leafref", (Object)new LeafrefSpecificationRFC6020Support()).put((Object)"union", (Object)new UnionSpecificationSupport()).build();

    AbstractTypeStatementSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public final String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<String, TypeStatement, EffectiveStatement<String, TypeStatement>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (BUILT_IN_TYPES.containsKey(stmt.getStatementArgument())) {
            return;
        }
        final QName typeQName = StmtContextUtils.parseNodeIdentifier(stmt, (String)((String)stmt.getStatementArgument()));
        ModelActionBuilder typeAction = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite typePrereq = typeAction.requiresCtx(stmt, TypeNamespace.class, (Object)typeQName, ModelProcessingPhase.EFFECTIVE_MODEL);
        typeAction.mutatesEffectiveCtx(stmt.getParentContext());
        typeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(typePrereq), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Type [%s] was not found.", (Object[])new Object[]{typeQName});
            }
        });
    }

    public final String internArgument(String rawArgument) {
        String found = (String)BUILT_IN_TYPES.get((Object)rawArgument);
        return found != null ? found : rawArgument;
    }

    public boolean hasArgumentSpecificSupports() {
        return !ARGUMENT_SPECIFIC_SUPPORTS.isEmpty();
    }

    public StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        return (StatementSupport)ARGUMENT_SPECIFIC_SUPPORTS.get((Object)argument);
    }

    protected final SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected final TypeStatement createDeclared(StmtContext<String, TypeStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularTypeStatement(ctx, substatements);
    }

    @Override
    protected final TypeStatement createEmptyDeclared(StmtContext<String, TypeStatement, ?> ctx) {
        TypeStatement builtin = BuiltinTypeStatement.lookup(ctx);
        return builtin != null ? builtin : new EmptyTypeStatement(ctx);
    }

    @Override
    protected final TypeEffectiveStatement<TypeStatement> createEffective(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement<TypeStatement> typeStmt = AbstractTypeStatementSupport.resolveType(ctx);
        TypeDefinition baseType = typeStmt.getTypeDefinition();
        if (baseType instanceof BinaryTypeDefinition) {
            return AbstractTypeStatementSupport.createBinary(ctx, (BinaryTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof BitsTypeDefinition) {
            return AbstractTypeStatementSupport.createBits(ctx, (BitsTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof BooleanTypeDefinition) {
            return AbstractTypeStatementSupport.createBoolean(ctx, (BooleanTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof DecimalTypeDefinition) {
            return AbstractTypeStatementSupport.createDecimal(ctx, (DecimalTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof EmptyTypeDefinition) {
            return AbstractTypeStatementSupport.createEmpty(ctx, (EmptyTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof EnumTypeDefinition) {
            return AbstractTypeStatementSupport.createEnum(ctx, (EnumTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof IdentityrefTypeDefinition) {
            return AbstractTypeStatementSupport.createIdentityref(ctx, (IdentityrefTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof InstanceIdentifierTypeDefinition) {
            return AbstractTypeStatementSupport.createInstanceIdentifier(ctx, (InstanceIdentifierTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof Int8TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newInt8Builder((Int8TypeDefinition)((Int8TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Int16TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newInt16Builder((Int16TypeDefinition)((Int16TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Int32TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newInt32Builder((Int32TypeDefinition)((Int32TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Int64TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newInt64Builder((Int64TypeDefinition)((Int64TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof LeafrefTypeDefinition) {
            return AbstractTypeStatementSupport.createLeafref(ctx, (LeafrefTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof StringTypeDefinition) {
            return AbstractTypeStatementSupport.createString(ctx, (StringTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof Uint8TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newUint8Builder((Uint8TypeDefinition)((Uint8TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Uint16TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newUint16Builder((Uint16TypeDefinition)((Uint16TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Uint32TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newUint32Builder((Uint32TypeDefinition)((Uint32TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof Uint64TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(ctx, declared, substatements, RestrictedTypes.newUint64Builder((Uint64TypeDefinition)((Uint64TypeDefinition)baseType), (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
        }
        if (baseType instanceof UnionTypeDefinition) {
            return AbstractTypeStatementSupport.createUnion(ctx, (UnionTypeDefinition)baseType, declared, substatements);
        }
        throw new IllegalStateException("Unhandled base type " + baseType);
    }

    @Override
    protected final EffectiveStatement<String, TypeStatement> createEmptyEffective(StmtContext<String, TypeStatement, EffectiveStatement<String, TypeStatement>> ctx, TypeStatement declared) {
        return AbstractTypeStatementSupport.resolveType(ctx);
    }

    static final SchemaPath typeEffectiveSchemaPath(StmtContext<?, ?, ?> stmtCtx) {
        SchemaPath path = (SchemaPath)stmtCtx.getSchemaPath().get();
        SchemaPath parent = path.getParent();
        QName parentQName = parent.getLastComponent();
        Preconditions.checkArgument((parentQName != null ? 1 : 0) != 0, (String)"Path %s has an empty parent", (Object)path);
        QName qname = path.getLastComponent().bindTo(parentQName.getModule()).intern();
        return parent.createChild(qname);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> resolveType(StmtContext<String, ?, ?> ctx) {
        String argument;
        switch (argument = (String)ctx.coerceStatementArgument()) {
            case "binary": {
                return BuiltinEffectiveStatement.BINARY;
            }
            case "boolean": {
                return BuiltinEffectiveStatement.BOOLEAN;
            }
            case "empty": {
                return BuiltinEffectiveStatement.EMPTY;
            }
            case "instance-identifier": {
                return BuiltinEffectiveStatement.INSTANCE_IDENTIFIER;
            }
            case "int8": {
                return BuiltinEffectiveStatement.INT8;
            }
            case "int16": {
                return BuiltinEffectiveStatement.INT16;
            }
            case "int32": {
                return BuiltinEffectiveStatement.INT32;
            }
            case "int64": {
                return BuiltinEffectiveStatement.INT64;
            }
            case "string": {
                return BuiltinEffectiveStatement.STRING;
            }
            case "uint8": {
                return BuiltinEffectiveStatement.UINT8;
            }
            case "uint16": {
                return BuiltinEffectiveStatement.UINT16;
            }
            case "uint32": {
                return BuiltinEffectiveStatement.UINT32;
            }
            case "uint64": {
                return BuiltinEffectiveStatement.UINT64;
            }
        }
        QName qname = StmtContextUtils.parseNodeIdentifier(ctx, (String)argument);
        StmtContext typedef = (StmtContext)SourceException.throwIfNull((Object)((StmtContext)ctx.getFromNamespace(TypeNamespace.class, (Object)qname)), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Type '%s' not found", (Object[])new Object[]{qname});
        return ((TypedefEffectiveStatement)typedef.buildEffective()).asTypeEffectiveStatement();
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBinary(StmtContext<?, ?, ?> ctx, BinaryTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        LengthRestrictedTypeBuilder builder = RestrictedTypes.newBinaryBuilder((BinaryTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof LengthEffectiveStatement)) continue;
            LengthEffectiveStatement length = (LengthEffectiveStatement)stmt;
            try {
                builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
            }
            catch (IllegalStateException e) {
                throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Multiple length constraints encountered", new Object[0]);
            }
            catch (InvalidLengthConstraintException e) {
                throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
            }
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBits(StmtContext<?, ?, ?> ctx, BitsTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        BitsTypeBuilder builder = RestrictedTypes.newBitsBuilder((BitsTypeDefinition)baseType, (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        YangVersion yangVersion = ctx.getRootVersion();
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof BitEffectiveStatement)) continue;
            SourceException.throwIf((yangVersion != YangVersion.VERSION_1_1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Restricted bits type is allowed only in YANG 1.1 version.", (Object[])new Object[0]);
            BitEffectiveStatement bitSubStmt = (BitEffectiveStatement)stmt;
            Optional declaredPosition = bitSubStmt.getDeclaredPosition();
            Uint32 effectivePos = declaredPosition.isEmpty() ? AbstractTypeStatementSupport.getBaseTypeBitPosition((String)bitSubStmt.argument(), baseType, ctx) : (Uint32)declaredPosition.get();
            builder.addBit(EffectiveTypeUtil.buildBit(bitSubStmt, effectivePos));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBoolean(StmtContext<?, ?, ?> ctx, BooleanTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newBooleanBuilder((BooleanTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createDecimal(StmtContext<?, ?, ?> ctx, DecimalTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        RangeRestrictedTypeBuilder builder = RestrictedTypes.newDecima64Builder((DecimalTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (stmt instanceof RangeEffectiveStatement) {
                RangeEffectiveStatement range = (RangeEffectiveStatement)stmt;
                builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
            }
            if (!(stmt instanceof FractionDigitsEffectiveStatement)) continue;
            Integer digits = (Integer)((FractionDigitsEffectiveStatement)stmt).argument();
            SourceException.throwIf((baseType.getFractionDigits() != digits.intValue() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Cannot override fraction-digits from base type %s to %s", (Object[])new Object[]{baseType, digits});
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createEmpty(StmtContext<?, ?, ?> ctx, EmptyTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newEmptyBuilder((EmptyTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createEnum(StmtContext<?, ?, ?> ctx, EnumTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        EnumerationTypeBuilder builder = RestrictedTypes.newEnumerationBuilder((EnumTypeDefinition)baseType, (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        YangVersion yangVersion = ctx.getRootVersion();
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof EnumEffectiveStatement)) continue;
            SourceException.throwIf((yangVersion != YangVersion.VERSION_1_1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Restricted enumeration type is allowed only in YANG 1.1 version.", (Object[])new Object[0]);
            EnumEffectiveStatement enumSubStmt = (EnumEffectiveStatement)stmt;
            Optional declaredValue = enumSubStmt.findFirstEffectiveSubstatementArgument(ValueEffectiveStatement.class);
            int effectiveValue = declaredValue.isEmpty() ? AbstractTypeStatementSupport.getBaseTypeEnumValue(((EnumStatement)enumSubStmt.getDeclared()).rawArgument(), baseType, ctx) : (Integer)declaredValue.orElseThrow();
            builder.addEnum(EffectiveTypeUtil.buildEnumPair(enumSubStmt, effectiveValue));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createIdentityref(StmtContext<?, ?, ?> ctx, IdentityrefTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newIdentityrefBuilder((IdentityrefTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createInstanceIdentifier(StmtContext<?, ?, ?> ctx, InstanceIdentifierTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        InstanceIdentifierTypeBuilder builder = RestrictedTypes.newInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            builder.setRequireInstance(((Boolean)((RequireInstanceEffectiveStatement)stmt).argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static <T extends RangeRestrictedTypeDefinition<T, N>, N extends Number> @NonNull TypeEffectiveStatement<TypeStatement> createIntegral(StmtContext<?, ?, ?> ctx, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, RangeRestrictedTypeBuilder<T, N> builder) {
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RangeEffectiveStatement)) continue;
            RangeEffectiveStatement rangeStmt = (RangeEffectiveStatement)stmt;
            builder.setRangeConstraint((ConstraintMetaDefinition)rangeStmt, (List)rangeStmt.argument());
        }
        try {
            return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
        }
        catch (InvalidRangeConstraintException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid range constraint: %s", new Object[]{e.getOffendingRanges()});
        }
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createLeafref(StmtContext<?, ?, ?> ctx, LeafrefTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        RequireInstanceRestrictedTypeBuilder builder = RestrictedTypes.newLeafrefBuilder((LeafrefTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            builder.setRequireInstance(((Boolean)((RequireInstanceEffectiveStatement)stmt).argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createString(StmtContext<?, ?, ?> ctx, StringTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        StringTypeBuilder builder = RestrictedTypes.newStringBuilder((StringTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (stmt instanceof LengthEffectiveStatement) {
                LengthEffectiveStatement length = (LengthEffectiveStatement)stmt;
                try {
                    builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
                }
                catch (IllegalStateException e) {
                    throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Multiple length constraints encountered", new Object[0]);
                }
                catch (InvalidLengthConstraintException e) {
                    throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
                }
            }
            if (!(stmt instanceof PatternEffectiveStatement)) continue;
            PatternConstraint pattern = (PatternConstraint)((PatternEffectiveStatement)stmt).argument();
            if (pattern != null) {
                builder.addPatternConstraint(pattern);
                continue;
            }
            LOG.debug("Ignoring empty pattern statement {}", (Object)stmt);
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createUnion(StmtContext<?, ?, ?> ctx, UnionTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newUnionBuilder((UnionTypeDefinition)baseType, (SchemaPath)AbstractTypeStatementSupport.typeEffectiveSchemaPath(ctx)));
    }

    private static Uint32 getBaseTypeBitPosition(String bitName, BitsTypeDefinition baseType, StmtContext<?, ?, ?> ctx) {
        for (BitsTypeDefinition.Bit baseTypeBit : baseType.getBits()) {
            if (!bitName.equals(baseTypeBit.getName())) continue;
            return baseTypeBit.getPosition();
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Bit '%s' is not a subset of its base bits type %s.", new Object[]{bitName, baseType.getQName()});
    }

    private static int getBaseTypeEnumValue(String enumName, EnumTypeDefinition baseType, StmtContext<?, ?, ?> ctx) {
        for (EnumTypeDefinition.EnumPair baseTypeEnumPair : baseType.getValues()) {
            if (!enumName.equals(baseTypeEnumPair.getName())) continue;
            return baseTypeEnumPair.getValue();
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Enum '%s' is not a subset of its base enumeration type %s.", new Object[]{enumName, baseType.getQName()});
    }
}

