/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class BuiltinTypeStatement
extends AbstractDeclaredStatement.WithRawStringArgument
implements TypeStatement {
    private static final ImmutableMap<String, BuiltinTypeStatement> BUILTINS;

    private static void putBuiltin(ImmutableMap.Builder<String, BuiltinTypeStatement> builder, String argument) {
        builder.put((Object)argument, (Object)new BuiltinTypeStatement(argument));
    }

    private BuiltinTypeStatement(String rawArgument) {
        super(Objects.requireNonNull(rawArgument));
    }

    static @Nullable TypeStatement lookup(StmtContext<String, TypeStatement, ?> ctx) {
        return (TypeStatement)BUILTINS.get(ctx.coerceStatementArgument());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "binary");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "boolean");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "empty");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "instance-identifier");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int8");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int16");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int32");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "int64");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "string");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint8");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint16");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint32");
        BuiltinTypeStatement.putBuiltin((ImmutableMap.Builder<String, BuiltinTypeStatement>)builder, "uint64");
        BUILTINS = builder.build();
    }
}

