/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.DecimalTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.Decimal64SpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class Decimal64SpecificationSupport
extends BaseStatementSupport<String, TypeStatement.Decimal64Specification, EffectiveStatement<String, TypeStatement.Decimal64Specification>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMandatory((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).addOptional((StatementDefinition)YangStmtMapping.RANGE).build();

    Decimal64SpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected TypeStatement.Decimal64Specification createDeclared(StmtContext<String, TypeStatement.Decimal64Specification, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new Decimal64SpecificationImpl(ctx, substatements);
    }

    @Override
    protected TypeStatement.Decimal64Specification createEmptyDeclared(StmtContext<String, TypeStatement.Decimal64Specification, ?> ctx) {
        throw Decimal64SpecificationSupport.noFracDigits(ctx);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.Decimal64Specification> createEffective(StmtContext<String, TypeStatement.Decimal64Specification, EffectiveStatement<String, TypeStatement.Decimal64Specification>> ctx, TypeStatement.Decimal64Specification declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        DecimalTypeBuilder builder = BaseTypes.decimalTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        for (EffectiveStatement stmt : substatements) {
            if (stmt instanceof FractionDigitsEffectiveStatement) {
                builder.setFractionDigits(((Integer)((FractionDigitsEffectiveStatement)stmt).argument()).intValue());
            }
            if (!(stmt instanceof RangeEffectiveStatement)) continue;
            RangeEffectiveStatement range = (RangeEffectiveStatement)stmt;
            builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.Decimal64Specification> createEmptyEffective(StmtContext<String, TypeStatement.Decimal64Specification, EffectiveStatement<String, TypeStatement.Decimal64Specification>> ctx, TypeStatement.Decimal64Specification declared) {
        throw Decimal64SpecificationSupport.noFracDigits(ctx);
    }

    private static SourceException noFracDigits(StmtContext<?, ?, ?> ctx) {
        return new SourceException("At least one fraction-digits statement has to be present", ctx.getStatementSourceReference());
    }
}

