/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class EnumSpecificationSupport
extends BaseStatementSupport<String, TypeStatement.EnumSpecification, EffectiveStatement<String, TypeStatement.EnumSpecification>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.ENUM).build();

    EnumSpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected TypeStatement.EnumSpecification createDeclared(StmtContext<String, TypeStatement.EnumSpecification, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new EnumSpecificationImpl(ctx, substatements);
    }

    @Override
    protected TypeStatement.EnumSpecification createEmptyDeclared(StmtContext<String, TypeStatement.EnumSpecification, ?> ctx) {
        throw EnumSpecificationSupport.noEnum(ctx);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.EnumSpecification> createEffective(StmtContext<String, TypeStatement.EnumSpecification, EffectiveStatement<String, TypeStatement.EnumSpecification>> ctx, TypeStatement.EnumSpecification declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        EnumerationTypeBuilder builder = BaseTypes.enumerationTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        Integer highestValue = null;
        for (EffectiveStatement stmt : substatements) {
            int effectiveValue;
            if (!(stmt instanceof EnumEffectiveStatement)) continue;
            EnumEffectiveStatement enumSubStmt = (EnumEffectiveStatement)stmt;
            Optional declaredValue = enumSubStmt.findFirstEffectiveSubstatementArgument(ValueEffectiveStatement.class);
            if (declaredValue.isEmpty()) {
                if (highestValue != null) {
                    SourceException.throwIf((highestValue == Integer.MAX_VALUE ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Enum '%s' must have a value statement", (Object[])new Object[]{enumSubStmt});
                    effectiveValue = highestValue + 1;
                } else {
                    effectiveValue = 0;
                }
            } else {
                effectiveValue = (Integer)declaredValue.orElseThrow();
            }
            EnumTypeDefinition.EnumPair pair = EffectiveTypeUtil.buildEnumPair(enumSubStmt, effectiveValue);
            if (highestValue == null || highestValue < pair.getValue()) {
                highestValue = pair.getValue();
            }
            builder.addEnum(pair);
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.EnumSpecification> createEmptyEffective(StmtContext<String, TypeStatement.EnumSpecification, EffectiveStatement<String, TypeStatement.EnumSpecification>> ctx, TypeStatement.EnumSpecification declared) {
        throw EnumSpecificationSupport.noEnum(ctx);
    }

    private static SourceException noEnum(StmtContext<?, ?, ?> ctx) {
        return new SourceException("At least one enum statement has to be present", ctx.getStatementSourceReference());
    }
}

