/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ChildSchemaNodeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.refine.RefineEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.EmptyLocalUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.EmptyUsesStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.FullCopiedUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.RegularLocalUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.RegularUsesStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.SimpleCopiedUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundlesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsesStatementSupport
extends BaseQNameStatementSupport<UsesStatement, UsesEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(UsesStatementSupport.class);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.USES).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final UsesStatementSupport INSTANCE = new UsesStatementSupport();

    private UsesStatementSupport() {
        super((StatementDefinition)YangStmtMapping.USES);
    }

    public static UsesStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(final StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement> usesNode) {
        if (!usesNode.isSupportedByFeatures()) {
            return;
        }
        super.onFullDefinitionDeclared(usesNode);
        ModelActionBuilder usesAction = usesNode.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final QName groupingName = (QName)usesNode.getStatementArgument();
        final ModelActionBuilder.Prerequisite sourceGroupingPre = usesAction.requiresCtx(usesNode, GroupingNamespace.class, (Object)groupingName, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite targetNodePre = usesAction.mutatesEffectiveCtx(usesNode.getParentContext());
        usesAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StatementContextBase targetNodeStmtCtx = (StatementContextBase)targetNodePre.resolve(ctx);
                StatementContextBase sourceGrpStmtCtx = (StatementContextBase)sourceGroupingPre.resolve(ctx);
                UsesStatementSupport.copyFromSourceToTarget(sourceGrpStmtCtx, targetNodeStmtCtx, (StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement>)usesNode);
                UsesStatementSupport.resolveUsesNode((StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement>)usesNode, targetNodeStmtCtx);
                StmtContextUtils.validateIfFeatureAndWhenOnListKeys((StmtContext)usesNode);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(sourceGroupingPre), (StatementSourceReference)usesNode.getStatementSourceReference(), (String)"Grouping '%s' was not resolved.", (Object[])new Object[]{groupingName});
                throw new InferenceException("Unknown error occurred.", usesNode.getStatementSourceReference());
            }
        });
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected UsesStatement createDeclared(StmtContext<QName, UsesStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularUsesStatement(ctx, substatements);
    }

    @Override
    protected UsesStatement createEmptyDeclared(StmtContext<QName, UsesStatement, ?> ctx) {
        return new EmptyUsesStatement(ctx);
    }

    @Override
    protected UsesEffectiveStatement createEffective(StmtContext<QName, UsesStatement, UsesEffectiveStatement> ctx, UsesStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        GroupingDefinition sourceGrouping = UsesStatementSupport.getSourceGrouping(ctx);
        int flags = UsesStatementSupport.historyAndStatusFlags(ctx, substatements);
        QName argument = (QName)ctx.coerceStatementArgument();
        if (((QName)declared.argument()).equals((Object)argument)) {
            return new RegularLocalUsesEffectiveStatement(declared, sourceGrouping, flags, substatements);
        }
        if (UsesStatementSupport.findFirstStatement(substatements, RefineEffectiveStatement.class) == null) {
            return new SimpleCopiedUsesEffectiveStatement(declared, argument, sourceGrouping, flags, substatements);
        }
        return new FullCopiedUsesEffectiveStatement(declared, argument, sourceGrouping, flags, substatements);
    }

    @Override
    protected UsesEffectiveStatement createEmptyEffective(StmtContext<QName, UsesStatement, UsesEffectiveStatement> ctx, UsesStatement declared) {
        GroupingDefinition sourceGrouping = UsesStatementSupport.getSourceGrouping(ctx);
        int flags = UsesStatementSupport.historyAndStatusFlags(ctx, ImmutableList.of());
        QName argument = (QName)ctx.coerceStatementArgument();
        return argument.equals(declared.argument()) ? new EmptyLocalUsesEffectiveStatement(declared, sourceGrouping, flags) : new SimpleCopiedUsesEffectiveStatement(declared, argument, sourceGrouping, flags);
    }

    static @NonNull ImmutableMap<// Could not load outer class - annotation placement on inner may be incorrect
    SchemaNodeIdentifier.Descendant, SchemaNode> indexRefines(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        LinkedHashMap<SchemaNodeIdentifier.Descendant, SchemaNode> refines = new LinkedHashMap<SchemaNodeIdentifier.Descendant, SchemaNode>();
        for (EffectiveStatement effectiveStatement : substatements) {
            if (!(effectiveStatement instanceof RefineEffectiveStatementImpl)) continue;
            RefineEffectiveStatementImpl refineStmt = (RefineEffectiveStatementImpl)effectiveStatement;
            refines.put((SchemaNodeIdentifier.Descendant)refineStmt.argument(), refineStmt.getRefineTargetNode());
        }
        return ImmutableMap.copyOf(refines);
    }

    private static GroupingDefinition getSourceGrouping(StmtContext<QName, ?, ?> ctx) {
        return (GroupingDefinition)((StmtContext)ctx.getFromNamespace(GroupingNamespace.class, (Object)((QName)ctx.coerceStatementArgument()))).buildEffective();
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void copyFromSourceToTarget(StmtContext.Mutable<?, ?, ?> sourceGrpStmtCtx, StatementContextBase<?, ?, ?> targetCtx, StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement> usesNode) {
        Collection declared = sourceGrpStmtCtx.mutableDeclaredSubstatements();
        Collection effective = sourceGrpStmtCtx.mutableEffectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        QNameModule newQNameModule = UsesStatementSupport.getNewQNameModule(targetCtx, sourceGrpStmtCtx);
        for (StmtContext.Mutable original : declared) {
            if (!original.isSupportedByFeatures() || !UsesStatementSupport.shouldCopy(original)) continue;
            original.copyAsChildOf(targetCtx, CopyType.ADDED_BY_USES, newQNameModule).ifPresent(buffer::add);
        }
        for (StmtContext.Mutable original : effective) {
            if (!UsesStatementSupport.shouldCopy(original)) continue;
            original.copyAsChildOf(targetCtx, CopyType.ADDED_BY_USES, newQNameModule).ifPresent(buffer::add);
        }
        targetCtx.addEffectiveSubstatements(buffer);
        usesNode.addAsEffectOfStatement(buffer);
    }

    private static boolean shouldCopy(StmtContext<?, ?, ?> stmt) {
        if (SchemaTreeEffectiveStatement.class.isAssignableFrom(stmt.getPublicDefinition().getEffectiveRepresentationClass())) {
            return true;
        }
        return StmtContextUtils.isUnknownStatement(stmt);
    }

    private static QNameModule getNewQNameModule(StmtContext<?, ?, ?> targetCtx, StmtContext<?, ?, ?> stmtContext) {
        if (targetCtx.getParentContext() == null) {
            return (QNameModule)targetCtx.getFromNamespace(ModuleCtxToModuleQName.class, targetCtx);
        }
        if (targetCtx.getPublicDefinition() == YangStmtMapping.AUGMENT) {
            return StmtContextUtils.getRootModuleQName(targetCtx);
        }
        Object targetStmtArgument = targetCtx.getStatementArgument();
        Object sourceStmtArgument = stmtContext.getStatementArgument();
        if (targetStmtArgument instanceof QName && sourceStmtArgument instanceof QName) {
            return ((QName)targetStmtArgument).getModule();
        }
        return null;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void resolveUsesNode(StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement> usesNode, StmtContext<?, ?, ?> targetNodeStmtCtx) {
        for (StmtContext.Mutable subStmtCtx : usesNode.mutableDeclaredSubstatements()) {
            if (!subStmtCtx.producesDeclared(RefineStatement.class) || !UsesStatementSupport.areFeaturesSupported(subStmtCtx)) continue;
            UsesStatementSupport.performRefine(subStmtCtx, targetNodeStmtCtx);
        }
    }

    private static boolean areFeaturesSupported(StmtContext<?, ?, ?> subStmtCtx) {
        return !YangVersion.VERSION_1_1.equals((Object)subStmtCtx.getRootVersion()) || subStmtCtx.isSupportedByFeatures();
    }

    private static void performRefine(StmtContext.Mutable<?, ?, ?> subStmtCtx, StmtContext<?, ?, ?> usesParentCtx) {
        Object refineArgument = subStmtCtx.getStatementArgument();
        InferenceException.throwIf((!(refineArgument instanceof SchemaNodeIdentifier) ? 1 : 0) != 0, (StatementSourceReference)subStmtCtx.getStatementSourceReference(), (String)"Invalid refine argument %s. It must be instance of SchemaNodeIdentifier.", (Object[])new Object[]{refineArgument});
        Optional<StmtContext<?, ?, ?>> optRefineTargetCtx = ChildSchemaNodeNamespace.findNode(usesParentCtx, (SchemaNodeIdentifier)refineArgument);
        InferenceException.throwIf((!optRefineTargetCtx.isPresent() ? 1 : 0) != 0, (StatementSourceReference)subStmtCtx.getStatementSourceReference(), (String)"Refine target node %s not found.", (Object[])new Object[]{refineArgument});
        StmtContext<?, ?, ?> refineTargetNodeCtx = optRefineTargetCtx.get();
        if (StmtContextUtils.isUnknownStatement(refineTargetNodeCtx)) {
            LOG.trace("Refine node '{}' in uses '{}' has target node unknown statement '{}'. Refine has been skipped. At line: {}", new Object[]{subStmtCtx.getStatementArgument(), subStmtCtx.coerceParentContext().getStatementArgument(), refineTargetNodeCtx.getStatementArgument(), subStmtCtx.getStatementSourceReference()});
            subStmtCtx.addAsEffectOfStatement(refineTargetNodeCtx);
            return;
        }
        Verify.verify((boolean)(refineTargetNodeCtx instanceof StatementContextBase));
        UsesStatementSupport.addOrReplaceNodes(subStmtCtx, (StatementContextBase)refineTargetNodeCtx);
        subStmtCtx.addAsEffectOfStatement(refineTargetNodeCtx);
    }

    private static void addOrReplaceNodes(StmtContext.Mutable<?, ?, ?> subStmtCtx, StatementContextBase<?, ?, ?> refineTargetNodeCtx) {
        for (StmtContext.Mutable refineSubstatementCtx : subStmtCtx.mutableDeclaredSubstatements()) {
            if (!UsesStatementSupport.isSupportedRefineSubstatement(refineSubstatementCtx)) continue;
            UsesStatementSupport.addOrReplaceNode(refineSubstatementCtx, refineTargetNodeCtx);
        }
    }

    private static void addOrReplaceNode(StmtContext.Mutable<?, ?, ?> refineSubstatementCtx, StatementContextBase<?, ?, ?> refineTargetNodeCtx) {
        StatementDefinition refineSubstatementDef = refineSubstatementCtx.getPublicDefinition();
        SourceException.throwIf((!UsesStatementSupport.isSupportedRefineTarget(refineSubstatementCtx, refineTargetNodeCtx) ? 1 : 0) != 0, (StatementSourceReference)refineSubstatementCtx.getStatementSourceReference(), (String)"Error in module '%s' in the refine of uses '%s': can not perform refine of '%s' for the target '%s'.", (Object[])new Object[]{refineSubstatementCtx.getRoot().getStatementArgument(), refineSubstatementCtx.coerceParentContext().getStatementArgument(), refineSubstatementCtx.getPublicDefinition(), refineTargetNodeCtx.getPublicDefinition()});
        if (UsesStatementSupport.isAllowedToAddByRefine(refineSubstatementDef)) {
            refineTargetNodeCtx.addEffectiveSubstatement(refineSubstatementCtx);
        } else {
            refineTargetNodeCtx.removeStatementFromEffectiveSubstatements(refineSubstatementDef);
            refineTargetNodeCtx.addEffectiveSubstatement(refineSubstatementCtx);
        }
    }

    private static boolean isAllowedToAddByRefine(StatementDefinition publicDefinition) {
        return YangStmtMapping.MUST.equals((Object)publicDefinition);
    }

    private static boolean isSupportedRefineSubstatement(StmtContext<?, ?, ?> refineSubstatementCtx) {
        Collection supportedRefineSubstatements = (Collection)refineSubstatementCtx.getFromNamespace(ValidationBundlesNamespace.class, (Object)ValidationBundlesNamespace.ValidationBundleType.SUPPORTED_REFINE_SUBSTATEMENTS);
        return supportedRefineSubstatements == null || supportedRefineSubstatements.isEmpty() || supportedRefineSubstatements.contains(refineSubstatementCtx.getPublicDefinition()) || StmtContextUtils.isUnknownStatement(refineSubstatementCtx);
    }

    private static boolean isSupportedRefineTarget(StmtContext<?, ?, ?> refineSubstatementCtx, StmtContext<?, ?, ?> refineTargetNodeCtx) {
        Collection supportedRefineTargets = YangValidationBundles.SUPPORTED_REFINE_TARGETS.get(refineSubstatementCtx.getPublicDefinition());
        return supportedRefineTargets == null || supportedRefineTargets.isEmpty() || supportedRefineTargets.contains(refineTargetNodeCtx.getPublicDefinition());
    }
}

