/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class LeafRefContextBuilder
implements Builder<LeafRefContext> {
    private final Map<QName, LeafRefContext> referencingChildren = new HashMap<QName, LeafRefContext>();
    private final Map<QName, LeafRefContext> referencedByChildren = new HashMap<QName, LeafRefContext>();
    private final Map<QName, LeafRefContext> referencedByLeafRefCtx = new HashMap<QName, LeafRefContext>();
    private final QName currentNodeQName;
    private final SchemaPath currentNodePath;
    private final SchemaContext schemaContext;
    private LeafRefPath leafRefTargetPath = null;
    private LeafRefPath absoluteLeafRefTargetPath = null;
    private String leafRefTargetPathString = "";
    private boolean isReferencedBy = false;
    private boolean isReferencing = false;

    LeafRefContextBuilder(QName currentNodeQName, SchemaPath currentNodePath, SchemaContext schemaContext) {
        this.currentNodeQName = Objects.requireNonNull(currentNodeQName);
        this.currentNodePath = Objects.requireNonNull(currentNodePath);
        this.schemaContext = schemaContext;
    }

    public LeafRefContext build() {
        LeafRefContext leafRefContext = new LeafRefContext(this);
        this.referencingChildren.clear();
        this.referencedByChildren.clear();
        this.referencedByLeafRefCtx.clear();
        return leafRefContext;
    }

    boolean isReferencedBy() {
        return this.isReferencedBy;
    }

    void setReferencedBy(boolean referencedBy) {
        this.isReferencedBy = referencedBy;
    }

    boolean isReferencing() {
        return this.isReferencing;
    }

    void setReferencing(boolean referencing) {
        this.isReferencing = referencing;
    }

    void addReferencingChild(LeafRefContext child, QName childQName) {
        this.referencingChildren.put(childQName, child);
    }

    Map<QName, LeafRefContext> getReferencingChilds() {
        return this.referencingChildren;
    }

    void addReferencedByChild(LeafRefContext child, QName childQName) {
        this.referencedByChildren.put(childQName, child);
    }

    Map<QName, LeafRefContext> getReferencedByChilds() {
        return this.referencedByChildren;
    }

    SchemaPath getCurrentNodePath() {
        return this.currentNodePath;
    }

    LeafRefPath getLeafRefTargetPath() {
        return this.leafRefTargetPath;
    }

    void setLeafRefTargetPath(LeafRefPath leafRefPath) {
        this.leafRefTargetPath = Objects.requireNonNull(leafRefPath);
    }

    String getLeafRefTargetPathString() {
        return this.leafRefTargetPathString;
    }

    void setLeafRefTargetPathString(String leafRefPathString) {
        this.leafRefTargetPathString = Objects.requireNonNull(leafRefPathString);
    }

    QName getCurrentNodeQName() {
        return this.currentNodeQName;
    }

    SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    LeafRefPath getAbsoluteLeafRefTargetPath() {
        if (this.isReferencing && this.absoluteLeafRefTargetPath == null) {
            this.absoluteLeafRefTargetPath = this.leafRefTargetPath.isAbsolute() ? this.leafRefTargetPath : LeafRefUtils.createAbsoluteLeafRefPath(this.leafRefTargetPath, this.currentNodePath, this.getLeafRefContextModule());
        }
        return this.absoluteLeafRefTargetPath;
    }

    Module getLeafRefContextModule() {
        Iterator it = this.currentNodePath.getPathFromRoot().iterator();
        QNameModule qnameModule = it.hasNext() ? ((QName)it.next()).getModule() : this.currentNodeQName.getModule();
        return this.schemaContext.findModule(qnameModule).orElse(null);
    }

    void addReferencedByLeafRefCtx(QName qname, LeafRefContext leafRef) {
        this.referencedByLeafRefCtx.put(qname, leafRef);
    }

    LeafRefContext getReferencedByLeafRefCtxByName(QName qname) {
        return this.referencedByLeafRefCtx.get(qname);
    }

    Map<QName, LeafRefContext> getAllReferencedByLeafRefCtxs() {
        return this.referencedByLeafRefCtx;
    }
}

