/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import java.util.Objects;

public class LeafRefYangSyntaxErrorException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String module;
    private final int line;
    private final int charPositionInLine;

    public LeafRefYangSyntaxErrorException(String module, int line, int charPositionInLine, String message) {
        this(module, line, charPositionInLine, message, null);
    }

    public LeafRefYangSyntaxErrorException(String module, int line, int charPositionInLine, String message, Throwable cause) {
        super(Objects.requireNonNull(message), cause);
        this.module = module;
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public String getModule() {
        return this.module;
    }

    public int getLine() {
        return this.line;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public String getFormattedMessage() {
        StringBuilder sb = new StringBuilder(this.getMessage());
        if (this.module != null) {
            sb.append(" in module ");
            sb.append(this.module);
        }
        if (this.line != 0) {
            sb.append(" on line ");
            sb.append(this.line);
            if (this.charPositionInLine != 0) {
                sb.append(" character ");
                sb.append(this.charPositionInLine);
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getFormattedMessage();
    }
}

