/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.DOMSourceAnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToCompositeNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToSimpleNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

abstract class InstanceIdToNodes<T extends YangInstanceIdentifier.PathArgument>
extends AbstractIdentifiable<T> {
    InstanceIdToNodes(T identifier) {
        super(identifier);
    }

    abstract InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument var1);

    abstract @NonNull NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument var1, Iterator<YangInstanceIdentifier.PathArgument> var2, Optional<NormalizedNode<?, ?>> var3);

    abstract boolean isMixin();

    private static Optional<DataSchemaNode> findChildSchemaNode(DataNodeContainer parent, QName child) {
        Optional<ChoiceSchemaNode> potential = parent.findDataChildByName(child);
        return potential.isPresent() ? potential : Optional.ofNullable(InstanceIdToNodes.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child));
    }

    static InstanceIdToNodes<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        Optional<DataSchemaNode> potential = InstanceIdToNodes.findChildSchemaNode(schema, child);
        Preconditions.checkArgument((boolean)potential.isPresent(), (String)"Supplied QName %s is not valid according to schema %s, potential children nodes: %s", (Object)child, (Object)schema, (Object)schema.getChildNodes());
        DataSchemaNode result = potential.get();
        if (schema instanceof DataSchemaNode && result.isAugmenting()) {
            return InstanceIdToNodes.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return InstanceIdToNodes.fromDataSchemaNode(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases()) {
                if (!InstanceIdToNodes.findChildSchemaNode((DataNodeContainer)caze, child).isPresent()) continue;
                return choice;
            }
        }
        return null;
    }

    private static InstanceIdToNodes<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        for (AugmentationSchemaNode aug : parentAug.getAvailableAugmentations()) {
            Optional potential = aug.findDataChildByName(child.getQName());
            if (!potential.isPresent()) continue;
            return new InstanceIdToCompositeNodes.AugmentationNormalization(aug, parent);
        }
        return InstanceIdToNodes.fromDataSchemaNode(child);
    }

    static InstanceIdToNodes<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new InstanceIdToCompositeNodes.ContainerTransformation((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return InstanceIdToNodes.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new InstanceIdToSimpleNodes.LeafNormalization((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new InstanceIdToCompositeNodes.ChoiceNodeNormalization((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return InstanceIdToNodes.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnydataSchemaNode) {
            return new AnydataNormalization((AnydataSchemaNode)potential);
        }
        if (potential instanceof AnyxmlSchemaNode) {
            return new AnyXmlNormalization((AnyxmlSchemaNode)potential);
        }
        return null;
    }

    private static InstanceIdToNodes<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixinNormalization(potential);
        }
        return potential.isUserOrdered() ? new InstanceIdToCompositeNodes.OrderedMapMixinNormalization(potential) : new InstanceIdToCompositeNodes.UnorderedMapMixinNormalization(potential);
    }

    private static InstanceIdToNodes<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        return potential.isUserOrdered() ? new InstanceIdToCompositeNodes.OrderedLeafListMixinNormalization(potential) : new InstanceIdToCompositeNodes.UnorderedLeafListMixinNormalization(potential);
    }

    private static final class AnyXmlNormalization
    extends AbstractOpaqueNormalization {
        AnyXmlNormalization(AnyxmlSchemaNode schema) {
            super((DataSchemaNode)schema);
        }

        @Override
        NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others, Optional<NormalizedNode<?, ?>> deepestChild) {
            NormalizedNodeBuilder<YangInstanceIdentifier.NodeIdentifier, DOMSource, DOMSourceAnyxmlNode> builder = Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier());
            if (deepestChild.isPresent()) {
                NormalizedNode<?, ?> child = deepestChild.get();
                Preconditions.checkState((boolean)(child instanceof DOMSourceAnyxmlNode), (String)"Invalid child %s", child);
                builder.withValue(((DOMSourceAnyxmlNode)child).getValue());
            }
            return builder.build();
        }
    }

    private static final class AnydataNormalization
    extends AbstractOpaqueNormalization {
        AnydataNormalization(AnydataSchemaNode schema) {
            super((DataSchemaNode)schema);
        }

        @Override
        NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others, Optional<NormalizedNode<?, ?>> deepestChild) {
            Preconditions.checkState((boolean)deepestChild.isPresent(), (Object)"Cannot instantiate anydata node without a value");
            NormalizedNode<?, ?> child = deepestChild.get();
            Preconditions.checkState((boolean)(child instanceof AnydataNode), (String)"Invalid child %s", child);
            return this.createAnydata((AnydataNode)child);
        }

        private <T> AnydataNode<T> createAnydata(AnydataNode<T> child) {
            return Builders.anydataBuilder(child.getValueObjectModel()).withValue(child.getValue()).withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier()).build();
        }
    }

    private static abstract class AbstractOpaqueNormalization
    extends InstanceIdToNodes<YangInstanceIdentifier.NodeIdentifier> {
        AbstractOpaqueNormalization(DataSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
        }

        @Override
        final InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return null;
        }

        @Override
        final boolean isMixin() {
            return false;
        }
    }

    private static final class UnkeyedListMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final InstanceIdToCompositeNodes.UnkeyedListItemNormalization innerNode;

        UnkeyedListMixinNormalization(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new InstanceIdToCompositeNodes.UnkeyedListItemNormalization(list);
        }

        CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.unkeyedListBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier());
        }

        @Override
        InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier()).getNodeType()) ? this.innerNode : null;
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }
}

