/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.LazyValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class LazyLeafOperations {
    private static final Logger LOG = LoggerFactory.getLogger(LazyLeafOperations.class);
    private static final String EXPENDABLE_PROP_NAME = "org.opendaylight.yangtools.yang.data.impl.schema.nodes.lazy-leaves";
    private static final boolean EXPENDABLE = Boolean.parseBoolean(System.getProperty("org.opendaylight.yangtools.yang.data.impl.schema.nodes.lazy-leaves", "true"));

    private LazyLeafOperations() {
    }

    public static boolean isEnabled() {
        return EXPENDABLE;
    }

    public static Optional<DataContainerChild<?, ?>> findChild(Map<YangInstanceIdentifier.PathArgument, Object> map, YangInstanceIdentifier.PathArgument key) {
        Object value = map.get(key);
        return value == null ? Optional.empty() : Optional.of(LazyLeafOperations.decodeChild(key, value));
    }

    public static @Nullable DataContainerChild<?, ?> getChild(Map<YangInstanceIdentifier.PathArgument, Object> map, YangInstanceIdentifier.PathArgument key) {
        Object value = map.get(key);
        return value == null ? null : LazyLeafOperations.decodeChild(key, value);
    }

    public static void putChild(Map<YangInstanceIdentifier.PathArgument, Object> map, DataContainerChild<?, ?> child) {
        DataContainerChild<?, ?> node = Objects.requireNonNull(child);
        map.put(node.getIdentifier(), EXPENDABLE ? LazyLeafOperations.encodeExpendableChild(node) : node);
    }

    public static @NonNull Collection<DataContainerChild<?, ?>> getValue(Map<YangInstanceIdentifier.PathArgument, Object> map) {
        return EXPENDABLE ? new LazyValues(map) : map.values();
    }

    static @NonNull LeafNode<?> coerceLeaf(YangInstanceIdentifier.PathArgument key, Object value) {
        Verify.verify((boolean)(key instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Unexpected value %s for child %s", (Object)value, (Object)key);
        return ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)key, value);
    }

    private static @Nullable DataContainerChild<?, ?> decodeChild(YangInstanceIdentifier.PathArgument key, @NonNull Object value) {
        return EXPENDABLE ? LazyLeafOperations.decodeExpendableChild(key, value) : LazyLeafOperations.verifyCast(value);
    }

    private static @NonNull DataContainerChild<?, ?> decodeExpendableChild(YangInstanceIdentifier.PathArgument key, @NonNull Object value) {
        return value instanceof DataContainerChild ? (LeafNode<?>)value : LazyLeafOperations.coerceLeaf(key, value);
    }

    private static @NonNull Object encodeExpendableChild(@NonNull DataContainerChild<?, ?> node) {
        return node instanceof LeafNode ? LazyLeafOperations.verifyEncode(((LeafNode)node).getValue()) : node;
    }

    private static @NonNull Object verifyEncode(@NonNull Object value) {
        Verify.verify((!(value instanceof DataContainerChild) ? 1 : 0) != 0, (String)"Unexpected leaf value %s", (Object)value);
        return value;
    }

    private static @NonNull DataContainerChild<?, ?> verifyCast(@NonNull Object value) {
        Verify.verify((boolean)(value instanceof DataContainerChild), (String)"Unexpected child %s", (Object)value);
        return (DataContainerChild)value;
    }

    static {
        if (!EXPENDABLE) {
            LOG.warn("Leaf nodes are treated as regular nodes. This option is deprecated and is schedule for removal.");
        }
    }
}

