/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AugmentationModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.CaseEnforcer;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class ChoiceModificationStrategy
extends AbstractNodeContainerModificationStrategy.Visible<ChoiceSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> SUPPORT = new NormalizedNodeContainerSupport(ChoiceNode.class, ImmutableChoiceNodeBuilder::create, ImmutableChoiceNodeBuilder::create);
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> childNodes;
    private final ImmutableMap<CaseEnforcer, Collection<CaseEnforcer>> exclusions;
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, CaseEnforcer> caseEnforcers;
    private final @NonNull ChoiceNode emptyNode;

    ChoiceModificationStrategy(ChoiceSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(SUPPORT, treeConfig, schema);
        ImmutableMap.Builder childBuilder = ImmutableMap.builder();
        ImmutableMap.Builder enforcerBuilder = ImmutableMap.builder();
        for (CaseSchemaNode caze : schema.getCases()) {
            CaseEnforcer enforcer = CaseEnforcer.forTree(caze, treeConfig);
            if (enforcer == null) continue;
            for (Map.Entry<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> entry : enforcer.getChildEntries()) {
                childBuilder.put((Object)((YangInstanceIdentifier.PathArgument)entry.getKey()), (Object)SchemaAwareApplyOperation.from(entry.getValue(), treeConfig));
                enforcerBuilder.put((Object)((YangInstanceIdentifier.PathArgument)entry.getKey()), (Object)enforcer);
            }
            for (Map.Entry<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> entry : enforcer.getAugmentationEntries()) {
                childBuilder.put((Object)((YangInstanceIdentifier.PathArgument)entry.getKey()), (Object)new AugmentationModificationStrategy((AugmentationSchemaNode)entry.getValue(), (DataNodeContainer)caze, treeConfig));
                enforcerBuilder.put((Object)((YangInstanceIdentifier.PathArgument)entry.getKey()), (Object)enforcer);
            }
        }
        this.childNodes = childBuilder.build();
        this.caseEnforcers = enforcerBuilder.build();
        HashMap<CaseEnforcer, ImmutableList> exclusionsBuilder = new HashMap<CaseEnforcer, ImmutableList>();
        for (CaseEnforcer e : this.caseEnforcers.values()) {
            exclusionsBuilder.put(e, ImmutableList.copyOf((Collection)Collections2.filter((Collection)this.caseEnforcers.values(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)e)))));
        }
        this.exclusions = ImmutableMap.copyOf(exclusionsBuilder);
        this.emptyNode = ImmutableNodes.choiceNode(schema.getQName());
    }

    @Override
    Optional<? extends TreeNode> apply(ModifiedNode modification, Optional<? extends TreeNode> storeMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, this.emptyNode, modification, storeMeta, version);
    }

    @Override
    TreeNode defaultTreeNode() {
        return ChoiceModificationStrategy.defaultTreeNode(this.emptyNode);
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument child) {
        return Optional.ofNullable((ModificationApplyOperation)this.childNodes.get((Object)child));
    }

    @Override
    void optionalVerifyValueChildren(NormalizedNode<?, ?> writtenValue) {
        this.enforceCases(writtenValue);
    }

    private void enforceCases(TreeNode tree) {
        this.enforceCases(tree.getData());
    }

    private void enforceCases(NormalizedNode<?, ?> normalizedNode) {
        Verify.verify((boolean)(normalizedNode instanceof ChoiceNode));
        Collection children = ((ChoiceNode)normalizedNode).getValue();
        if (!children.isEmpty()) {
            DataContainerChild firstChild = (DataContainerChild)children.iterator().next();
            CaseEnforcer enforcer = (CaseEnforcer)Verify.verifyNotNull((Object)((CaseEnforcer)this.caseEnforcers.get((Object)firstChild.getIdentifier())), (String)"Case enforcer cannot be null. Most probably, child node %s of choice node %s does not belong in current tree type.", (Object[])new Object[]{firstChild.getIdentifier(), normalizedNode.getIdentifier()});
            for (CaseEnforcer other : (Collection)this.exclusions.get((Object)enforcer)) {
                for (YangInstanceIdentifier.PathArgument id : other.getAllChildIdentifiers()) {
                    Optional maybeChild = NormalizedNodes.getDirectChild(normalizedNode, (YangInstanceIdentifier.PathArgument)id);
                    Preconditions.checkArgument((!maybeChild.isPresent() ? 1 : 0) != 0, (String)"Child %s (from case %s) implies non-presence of child %s (from case %s), which is %s", (Object[])new Object[]{firstChild.getIdentifier(), enforcer, id, other, maybeChild.orElse(null)});
                }
            }
            enforcer.enforceOnTreeNode(normalizedNode);
        }
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyMerge(modification, currentMeta, version);
        this.enforceCases(ret);
        return ret;
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode<?, ?> newValue, Optional<? extends TreeNode> currentMeta, Version version) {
        TreeNode ret = super.applyWrite(modification, newValue, currentMeta, version);
        this.enforceCases(ret);
        return ret;
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyTouch(modification, currentMeta, version);
        this.enforceCases(ret);
        return ret;
    }
}

