/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.transform;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

class QNameModuleReplacementFunction
implements Function<QName, QName> {
    private final Map<QNameModule, QNameModule> mapping;

    QNameModuleReplacementFunction(Map<QNameModule, QNameModule> mapping) {
        this.mapping = Objects.requireNonNull(mapping);
    }

    @Override
    public QName apply(QName input) {
        QNameModule potential = this.mapping.get(input.getModule());
        if (potential != null) {
            return QName.create((QNameModule)potential, (String)input.getLocalName()).intern();
        }
        return input;
    }
}

