/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.controller.remote.rpc.AbstractRemoteImplementation;
import org.opendaylight.controller.remote.rpc.RemoteDOMRpcFuture;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.messages.ExecuteRpc;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class RemoteRpcImplementation
extends AbstractRemoteImplementation<ExecuteRpc>
implements DOMRpcImplementation {
    RemoteRpcImplementation(ActorRef remoteInvoker, RemoteOpsProviderConfig config) {
        super(remoteInvoker, config);
    }

    public ListenableFuture<DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        return new RemoteDOMRpcFuture(rpc.getType(), this.ask(ExecuteRpc.from(rpc, input)));
    }

    public long invocationCost() {
        return 2L;
    }
}

