/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
public class ConnectionEntry
implements Immutable {
    private final Consumer<Response<?, ?>> callback;
    private final Request<?, ?> request;
    private final long enqueuedTicks;

    ConnectionEntry(Request<?, ?> request, Consumer<Response<?, ?>> callback, long now) {
        this.request = Objects.requireNonNull(request);
        this.callback = Objects.requireNonNull(callback);
        this.enqueuedTicks = now;
    }

    ConnectionEntry(ConnectionEntry entry) {
        this(entry.request, entry.callback, entry.enqueuedTicks);
    }

    public final Consumer<Response<?, ?>> getCallback() {
        return this.callback;
    }

    public final Request<?, ?> getRequest() {
        return this.request;
    }

    public void complete(Response<?, ?> response) {
        this.callback.accept(response);
    }

    public final long getEnqueuedTicks() {
        return this.enqueuedTicks;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("request", this.request).add("enqueuedTicks", this.enqueuedTicks);
    }
}

