/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SnapshotSelectionCriteria;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.InitialClientActorContext;
import org.opendaylight.controller.cluster.access.client.RecoveredClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Long;

final class SavingClientActorBehavior
extends RecoveredClientActorBehavior<InitialClientActorContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SavingClientActorBehavior.class);
    private final ClientIdentifier myId;

    SavingClientActorBehavior(InitialClientActorContext context, ClientIdentifier nextId) {
        super(context);
        this.myId = Objects.requireNonNull(nextId);
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveCommand(Object command) {
        if (command instanceof SaveSnapshotFailure) {
            LOG.error("{}: failed to persist state", (Object)this.persistenceId(), (Object)((SaveSnapshotFailure)command).cause());
            return null;
        }
        if (command instanceof SaveSnapshotSuccess) {
            LOG.debug("{}: got command: {}", (Object)this.persistenceId(), command);
            SaveSnapshotSuccess saved = (SaveSnapshotSuccess)command;
            ((InitialClientActorContext)this.context()).deleteSnapshots(new SnapshotSelectionCriteria(Long.MaxValue(), saved.metadata().timestamp() - 1L, 0L, 0L));
            return this;
        }
        if (command instanceof DeleteSnapshotsSuccess) {
            LOG.debug("{}: got command: {}", (Object)this.persistenceId(), command);
        } else if (command instanceof DeleteSnapshotsFailure) {
            LOG.warn("{}: failed to delete prior snapshots", (Object)this.persistenceId(), (Object)((DeleteSnapshotsFailure)command).cause());
        } else {
            LOG.debug("{}: stashing command {}", (Object)this.persistenceId(), command);
            ((InitialClientActorContext)this.context()).stash();
            return this;
        }
        ((InitialClientActorContext)this.context()).unstash();
        return ((InitialClientActorContext)this.context()).createBehavior(this.myId);
    }
}

