/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.SchemaAwareXMLStreamWriterUtils;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.SchemaTracker;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;

final class SchemaAwareXMLStreamNormalizedNodeStreamWriter
extends XMLStreamNormalizedNodeStreamWriter<TypedDataSchemaNode>
implements EffectiveModelContextProvider {
    private final SchemaTracker tracker;
    private final SchemaAwareXMLStreamWriterUtils streamUtils;

    SchemaAwareXMLStreamNormalizedNodeStreamWriter(XMLStreamWriter writer, EffectiveModelContext context, SchemaTracker tracker) {
        super(writer);
        this.tracker = Objects.requireNonNull(tracker);
        this.streamUtils = new SchemaAwareXMLStreamWriterUtils(context);
    }

    @Override
    String encodeValue(ValueWriter xmlWriter, Object value, TypedDataSchemaNode schemaNode) throws XMLStreamException {
        return this.streamUtils.encodeValue(xmlWriter, (SchemaNode)schemaNode, schemaNode.getType(), value, schemaNode.getQName().getModule());
    }

    @Override
    String encodeAnnotationValue(ValueWriter xmlWriter, QName qname, Object value) throws XMLStreamException {
        Optional optAnnotation = AnnotationSchemaNode.find((SchemaContext)this.streamUtils.getEffectiveModelContext(), (QName)qname);
        if (optAnnotation.isPresent()) {
            AnnotationSchemaNode schema = (AnnotationSchemaNode)optAnnotation.get();
            return this.streamUtils.encodeValue(xmlWriter, (SchemaNode)schema, schema.getType(), value, qname.getModule());
        }
        Preconditions.checkArgument((!qname.getRevision().isPresent() ? 1 : 0) != 0, (String)"Failed to find bound annotation %s", (Object)qname);
        Preconditions.checkArgument((boolean)(value instanceof String), (String)"Invalid non-string value %s for unbound annotation %s", (Object)value, (Object)qname);
        return (String)value;
    }

    @Override
    void startList(YangInstanceIdentifier.NodeIdentifier name) {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
    }

    @Override
    void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        this.tracker.startListItem(name);
        this.startElement(name.getNodeType());
    }

    public void endNode() throws IOException {
        Object schema = this.tracker.endNode();
        if (schema instanceof ListSchemaNode || schema instanceof LeafListSchemaNode) {
            Object parent = this.tracker.getParent();
            if (parent == schema) {
                this.endElement();
            }
        } else if (schema instanceof ContainerLike || schema instanceof LeafSchemaNode || schema instanceof AnydataSchemaNode || schema instanceof AnyxmlSchemaNode) {
            this.endElement();
        }
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.tracker.startLeafNode(name);
        this.startElement(name.getNodeType());
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.tracker.startLeafSetEntryNode(name);
        this.startElement(name.getNodeType());
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startLeafSet(name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startLeafSet(name);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        SchemaNode schema = this.tracker.startContainerNode(name);
        this.startElement(schema.getQName());
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startChoiceNode(name);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.tracker.startAugmentationNode(identifier);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        SchemaNode schema = this.tracker.startYangModeledAnyXmlNode(name);
        this.startElement(schema.getQName());
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.tracker.startAnyxmlNode(name);
            this.startElement(name.getNodeType());
            return true;
        }
        return false;
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.streamUtils.getEffectiveModelContext();
    }

    public void scalarValue(Object value) throws IOException {
        Object current = this.tracker.getParent();
        if (current instanceof TypedDataSchemaNode) {
            this.writeValue(value, (TypedDataSchemaNode)current);
        } else if (current instanceof AnydataSchemaNode) {
            this.anydataValue(value);
        } else {
            throw new IllegalStateException("Unexpected scalar value " + value + " with " + current);
        }
    }

    public void domSourceValue(DOMSource value) throws IOException {
        Object current = this.tracker.getParent();
        Preconditions.checkState((boolean)(current instanceof AnyxmlSchemaNode), (String)"Unexpected scala value %s with %s", (Object)value, (Object)current);
        this.anyxmlValue(value);
    }

    @Override
    void startAnydata(YangInstanceIdentifier.NodeIdentifier name) {
        this.tracker.startAnydataNode(name);
    }
}

