/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UnionXmlCodec<T>
implements XmlCodec<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UnionXmlCodec.class);
    private final ImmutableList<XmlCodec<?>> codecs;

    UnionXmlCodec(List<XmlCodec<?>> codecs) {
        this.codecs = ImmutableList.copyOf(codecs);
    }

    static UnionXmlCodec<?> create(UnionTypeDefinition type, List<XmlCodec<?>> codecs) {
        Iterator<XmlCodec<?>> it = codecs.iterator();
        Verify.verify((boolean)it.hasNext(), (String)"Union %s has no subtypes", (Object)type);
        Class dataClass = it.next().getDataType();
        while (it.hasNext()) {
            Class next = it.next().getDataType();
            if (dataClass.equals(next)) continue;
            LOG.debug("Type {} has diverse data classes: {} and {}", new Object[]{type, dataClass, next});
            return new Diverse(codecs);
        }
        LOG.debug("Type {} has single data class {}", (Object)type, (Object)dataClass);
        return new SingleType(dataClass, codecs);
    }

    public final T parseValue(NamespaceContext ctx, String str) {
        for (XmlCodec codec : this.codecs) {
            Object ret;
            try {
                ret = codec.parseValue(ctx, str);
            }
            catch (RuntimeException e) {
                LOG.debug("Codec {} did not accept input '{}'", new Object[]{codec, str, e});
                continue;
            }
            return this.getDataType().cast(ret);
        }
        throw new IllegalArgumentException("Invalid value \"" + str + "\" for union type.");
    }

    @Override
    public void writeValue(XMLStreamWriter ctx, Object value) throws XMLStreamException {
        for (XmlCodec codec : this.codecs) {
            if (!codec.getDataType().isInstance(value)) {
                LOG.debug("Codec {} cannot accept input {}, skipping it", (Object)codec, value);
                continue;
            }
            XmlCodec objCodec = codec;
            try {
                objCodec.writeValue(ctx, value);
                return;
            }
            catch (RuntimeException e) {
                LOG.debug("Codec {} failed to serialize {}", new Object[]{codec, value, e});
            }
        }
        throw new IllegalArgumentException("No codec would accept value \"" + value + "\"");
    }

    private static final class SingleType<T>
    extends UnionXmlCodec<T> {
        private final Class<T> dataClass;

        SingleType(Class<T> dataClass, List<XmlCodec<?>> codecs) {
            super(codecs);
            this.dataClass = Objects.requireNonNull(dataClass);
        }

        public Class<T> getDataType() {
            return this.dataClass;
        }
    }

    private static final class Diverse
    extends UnionXmlCodec<Object> {
        Diverse(List<XmlCodec<?>> codecs) {
            super(codecs);
        }

        public Class<Object> getDataType() {
            return Object.class;
        }
    }
}

