/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyxmlSchemaNode;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointChild;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.data.api.YangLibraryConstants;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointSchemaNode;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceAnydata;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceMountPointChild;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.StreamWriterFacade;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.util.AbstractMountPointDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnydataNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.MountPointData;
import org.opendaylight.yangtools.yang.data.util.MultipleEntryDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.OperationAsContainer;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.YangModeledAnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Beta
public final class XmlParserStream
implements Closeable,
Flushable {
    @Deprecated
    public static final QNameModule LEGACY_ATTRIBUTE_NAMESPACE = QNameModule.create((URI)URI.create("")).intern();
    private static final Logger LOG = LoggerFactory.getLogger(XmlParserStream.class);
    private static final String XML_STANDARD_VERSION = "1.0";
    private static final String COM_SUN_TRANSFORMER = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static final TransformerFactory TRANSFORMER_FACTORY;
    private final Map<String, Optional<QNameModule>> resolvedNamespaces = new HashMap<String, Optional<QNameModule>>();
    private final Map<String, QNameModule> rawNamespaces = new HashMap<String, QNameModule>();
    private final NormalizedNodeStreamWriter writer;
    private final XmlCodecFactory codecs;
    private final DataSchemaNode parentNode;
    private final boolean strictParsing;

    private XmlParserStream(NormalizedNodeStreamWriter writer, XmlCodecFactory codecs, DataSchemaNode parentNode, boolean strictParsing) {
        this.writer = Objects.requireNonNull(writer);
        this.codecs = Objects.requireNonNull(codecs);
        this.parentNode = parentNode;
        this.strictParsing = strictParsing;
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, XmlCodecFactory codecs, SchemaNode parentNode) {
        return XmlParserStream.create(writer, codecs, parentNode, true);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, XmlCodecFactory codecs, SchemaNode parentNode, boolean strictParsing) {
        DataSchemaNode parent;
        if (parentNode instanceof DataSchemaNode) {
            parent = (DataSchemaNode)parentNode;
        } else if (parentNode instanceof OperationDefinition) {
            parent = OperationAsContainer.of((OperationDefinition)((OperationDefinition)parentNode));
        } else {
            throw new IllegalArgumentException("Illegal parent node " + parentNode);
        }
        return new XmlParserStream(writer, codecs, parent, strictParsing);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, EffectiveModelContext schemaContext, SchemaNode parentNode) {
        return XmlParserStream.create(writer, schemaContext, parentNode, true);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, EffectiveModelContext schemaContext, SchemaNode parentNode, boolean strictParsing) {
        return XmlParserStream.create(writer, XmlCodecFactory.create(schemaContext), parentNode, strictParsing);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, MountPointContext mountCtx, SchemaNode parentNode) {
        return XmlParserStream.create(writer, mountCtx, parentNode, true);
    }

    public static XmlParserStream create(NormalizedNodeStreamWriter writer, MountPointContext mountCtx, SchemaNode parentNode, boolean strictParsing) {
        return XmlParserStream.create(writer, XmlCodecFactory.create(mountCtx), parentNode, strictParsing);
    }

    public XmlParserStream parse(XMLStreamReader reader) throws XMLStreamException, URISyntaxException, IOException, SAXException {
        if (reader.hasNext()) {
            ContainerNodeDataWithSchema nodeDataWithSchema;
            reader.nextTag();
            if (this.parentNode instanceof ContainerLike) {
                nodeDataWithSchema = new ContainerNodeDataWithSchema((ContainerLike)this.parentNode);
            } else if (this.parentNode instanceof ListSchemaNode) {
                nodeDataWithSchema = new ListNodeDataWithSchema((ListSchemaNode)this.parentNode);
            } else if (this.parentNode instanceof YangModeledAnyxmlSchemaNode) {
                nodeDataWithSchema = new YangModeledAnyXmlNodeDataWithSchema((YangModeledAnyxmlSchemaNode)this.parentNode);
            } else if (this.parentNode instanceof AnyxmlSchemaNode) {
                nodeDataWithSchema = new AnyXmlNodeDataWithSchema((AnyxmlSchemaNode)this.parentNode);
            } else if (this.parentNode instanceof LeafSchemaNode) {
                nodeDataWithSchema = new LeafNodeDataWithSchema((LeafSchemaNode)this.parentNode);
            } else if (this.parentNode instanceof LeafListSchemaNode) {
                nodeDataWithSchema = new LeafListNodeDataWithSchema((LeafListSchemaNode)this.parentNode);
            } else if (this.parentNode instanceof AnydataSchemaNode) {
                nodeDataWithSchema = new AnydataNodeDataWithSchema((AnydataSchemaNode)this.parentNode);
            } else {
                throw new IllegalStateException("Unsupported schema node type " + this.parentNode.getClass() + ".");
            }
            this.read(reader, (AbstractNodeDataWithSchema<?>)nodeDataWithSchema, reader.getLocalName());
            nodeDataWithSchema.write(this.writer);
        }
        return this;
    }

    @Beta
    public XmlParserStream traverse(DOMSource src) throws XMLStreamException, URISyntaxException, IOException, SAXException {
        return this.parse((XMLStreamReader)((Object)new DOMSourceXMLStreamReader(src)));
    }

    private ImmutableMap<QName, Object> getElementAttributes(XMLStreamReader in) {
        Preconditions.checkState((boolean)in.isStartElement(), (Object)"Attributes can be extracted only from START_ELEMENT.");
        LinkedHashMap<QName, Object> attributes = new LinkedHashMap<QName, Object>();
        for (int attrIndex = 0; attrIndex < in.getAttributeCount(); ++attrIndex) {
            String attributeNS = in.getAttributeNamespace(attrIndex);
            if ("http://www.w3.org/2000/xmlns/".equals(attributeNS)) continue;
            String localName = in.getAttributeLocalName(attrIndex);
            String attrValue = in.getAttributeValue(attrIndex);
            if (Strings.isNullOrEmpty((String)attributeNS)) {
                StreamWriterFacade.warnLegacyAttribute(localName);
                attributes.put(QName.create((QNameModule)LEGACY_ATTRIBUTE_NAMESPACE, (String)localName), attrValue);
                continue;
            }
            Optional<QNameModule> optModule = this.resolveXmlNamespace(attributeNS);
            if (optModule.isPresent()) {
                QName qname = QName.create((QNameModule)optModule.get(), (String)localName);
                Optional optAnnotation = AnnotationSchemaNode.find((SchemaContext)this.codecs.getEffectiveModelContext(), (QName)qname);
                if (optAnnotation.isPresent()) {
                    AnnotationSchemaNode schema = (AnnotationSchemaNode)optAnnotation.get();
                    Object value = ((XmlCodec)this.codecs.codecFor((TypeAware)schema)).parseValue(in.getNamespaceContext(), attrValue);
                    attributes.put(schema.getQName(), value);
                    continue;
                }
                LOG.debug("Annotation for {} not found, using legacy QName", (Object)qname);
            }
            attributes.put(QName.create((QNameModule)this.rawXmlNamespace(attributeNS), (String)localName), attrValue);
        }
        return ImmutableMap.copyOf(attributes);
    }

    private static Document readAnyXmlValue(XMLStreamReader in) throws XMLStreamException {
        XMLStreamReader inWrapper = in.getVersion() == null ? new StreamReaderDelegate(in){

            @Override
            public String getVersion() {
                String ver = super.getVersion();
                return ver != null ? ver : XmlParserStream.XML_STANDARD_VERSION;
            }
        } : in;
        DOMResult result = new DOMResult();
        try {
            TRANSFORMER_FACTORY.newTransformer().transform(new StAXSource(inWrapper), result);
        }
        catch (TransformerException e) {
            throw new XMLStreamException("Unable to read anyxml value", e);
        }
        return (Document)result.getNode();
    }

    private void read(XMLStreamReader in, AbstractNodeDataWithSchema<?> parent, String rootElement) throws XMLStreamException {
        if (!in.hasNext()) {
            return;
        }
        if (parent instanceof LeafNodeDataWithSchema || parent instanceof LeafListEntryNodeDataWithSchema) {
            parent.setAttributes(this.getElementAttributes(in));
            this.setValue((SimpleNodeDataWithSchema)parent, in.getElementText().trim(), in.getNamespaceContext());
            if (XmlParserStream.isNextEndDocument(in)) {
                return;
            }
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            return;
        }
        if (parent instanceof ListEntryNodeDataWithSchema || parent instanceof ContainerNodeDataWithSchema) {
            parent.setAttributes(this.getElementAttributes(in));
        }
        if (parent instanceof LeafListNodeDataWithSchema || parent instanceof ListNodeDataWithSchema) {
            String xmlElementName = in.getLocalName();
            while (xmlElementName.equals(parent.getSchema().getQName().getLocalName())) {
                this.read(in, XmlParserStream.newEntryNode(parent), rootElement);
                if (in.getEventType() == 8 || in.getEventType() == 2) break;
                xmlElementName = in.getLocalName();
            }
            return;
        }
        if (parent instanceof AnyXmlNodeDataWithSchema) {
            this.setValue((SimpleNodeDataWithSchema<?>)((AnyXmlNodeDataWithSchema)parent), XmlParserStream.readAnyXmlValue(in), in.getNamespaceContext());
            if (XmlParserStream.isNextEndDocument(in)) {
                return;
            }
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            return;
        }
        if (parent instanceof AnydataNodeDataWithSchema) {
            AnydataNodeDataWithSchema anydata = (AnydataNodeDataWithSchema)parent;
            anydata.setObjectModel(DOMSourceAnydata.class);
            anydata.setAttributes(this.getElementAttributes(in));
            this.setValue((SimpleNodeDataWithSchema<?>)anydata, XmlParserStream.readAnyXmlValue(in), in.getNamespaceContext());
            if (XmlParserStream.isNextEndDocument(in)) {
                return;
            }
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            return;
        }
        if (parent instanceof YangModeledAnyxmlSchemaNode) {
            parent.setAttributes(this.getElementAttributes(in));
        }
        block1 : switch (in.nextTag()) {
            case 1: {
                HashSet<AbstractMap.SimpleImmutableEntry<String, String>> namesakes = new HashSet<AbstractMap.SimpleImmutableEntry<String, String>>();
                while (in.hasNext()) {
                    URI nsUri;
                    String xmlElementName = in.getLocalName();
                    DataSchemaNode parentSchema = parent.getSchema();
                    String parentSchemaName = parentSchema.getQName().getLocalName();
                    if (parentSchemaName.equals(xmlElementName) && in.getEventType() == 2) {
                        if (XmlParserStream.isNextEndDocument(in) || XmlParserStream.isAtElement(in)) break block1;
                        in.nextTag();
                        break block1;
                    }
                    if (in.isEndElement() && rootElement.equals(xmlElementName)) break block1;
                    if (parentSchema instanceof YangModeledAnyxmlSchemaNode) {
                        parentSchema = ((YangModeledAnyxmlSchemaNode)parentSchema).getSchemaOfAnyXmlData();
                    }
                    String elementNS = in.getNamespaceURI();
                    boolean added = namesakes.add(new AbstractMap.SimpleImmutableEntry<String, String>(elementNS, xmlElementName));
                    try {
                        nsUri = this.rawXmlNamespace(elementNS).getNamespace();
                    }
                    catch (IllegalArgumentException e) {
                        throw new XMLStreamException("Failed to convert namespace " + xmlElementName, in.getLocation(), e);
                    }
                    Deque childDataSchemaNodes = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentSchema, (String)xmlElementName, (URI)nsUri);
                    if (!childDataSchemaNodes.isEmpty()) {
                        boolean elementList = XmlParserStream.isElementList(childDataSchemaNodes);
                        if (!added && !elementList) {
                            throw new XMLStreamException(String.format("Duplicate element \"%s\" in namespace \"%s\" with parent \"%s\" in XML input", xmlElementName, elementNS, parentSchema), in.getLocation());
                        }
                        this.read(in, ((CompositeNodeDataWithSchema)parent).addChild(childDataSchemaNodes, elementList ? CompositeNodeDataWithSchema.ChildReusePolicy.REUSE : CompositeNodeDataWithSchema.ChildReusePolicy.NOOP), rootElement);
                        continue;
                    }
                    if (parent instanceof AbstractMountPointDataWithSchema) {
                        Optional optMount;
                        if (parentSchema instanceof ContainerSchemaNode) {
                            optMount = MountPointSchemaNode.streamAll((ContainerSchemaNode)((ContainerSchemaNode)parentSchema)).findFirst();
                        } else if (parentSchema instanceof ListSchemaNode) {
                            optMount = MountPointSchemaNode.streamAll((ListSchemaNode)((ListSchemaNode)parentSchema)).findFirst();
                        } else {
                            throw new XMLStreamException("Unhandled mount-aware schema " + parentSchema, in.getLocation());
                        }
                        if (optMount.isPresent()) {
                            MountPointIdentifier mountId = MountPointIdentifier.of((QName)((MountPointSchemaNode)optMount.get()).getQName());
                            LOG.debug("Assuming node {} and namespace {} belongs to mount point {}", new Object[]{xmlElementName, nsUri, mountId});
                            Optional optFactory = this.codecs.mountPointContext().findMountPoint(mountId);
                            if (optFactory.isPresent()) {
                                MountPointData mountData = ((AbstractMountPointDataWithSchema)parent).getMountPointData(mountId, (MountPointContextFactory)optFactory.get());
                                XmlParserStream.addMountPointChild(mountData, nsUri, xmlElementName, new DOMSource(XmlParserStream.readAnyXmlValue(in).getDocumentElement()));
                                continue;
                            }
                            LOG.debug("Mount point {} not attached", (Object)mountId);
                        }
                    }
                    if (this.strictParsing) {
                        throw new XMLStreamException(String.format("Schema for node with name %s and namespace %s does not exist at %s", xmlElementName, elementNS, parentSchema.getPath()), in.getLocation());
                    }
                    LOG.debug("Skipping unknown node ns=\"{}\" localName=\"{}\" at path {}", new Object[]{elementNS, xmlElementName, parentSchema.getPath()});
                    XmlParserStream.skipUnknownNode(in);
                }
                break;
            }
            case 2: {
                if (XmlParserStream.isNextEndDocument(in) || XmlParserStream.isAtElement(in)) break;
                in.nextTag();
                break;
            }
        }
    }

    private static boolean isElementList(Deque<DataSchemaNode> childDataSchemaNodes) {
        DataSchemaNode last = childDataSchemaNodes.getLast();
        return last instanceof ListSchemaNode || last instanceof LeafListSchemaNode;
    }

    private static void addMountPointChild(MountPointData mount, URI namespace, String localName, DOMSource source) {
        DOMSourceMountPointChild child = new DOMSourceMountPointChild(source);
        if (YangLibraryConstants.MODULE_NAMESPACE.equals(namespace)) {
            Optional optName = YangLibraryConstants.ContainerName.forLocalName((String)localName);
            if (optName.isPresent()) {
                mount.setContainer((YangLibraryConstants.ContainerName)optName.get(), (MountPointChild)child);
                return;
            }
            LOG.warn("Encountered unknown element {} from YANG Library namespace", (Object)localName);
        } else if (SchemaMountConstants.RFC8528_MODULE.getNamespace().equals(namespace)) {
            mount.setSchemaMounts((MountPointChild)child);
            return;
        }
        mount.addChild((MountPointChild)child);
    }

    private static boolean isNextEndDocument(XMLStreamReader in) throws XMLStreamException {
        return !in.hasNext() || in.next() == 8;
    }

    private static boolean isAtElement(XMLStreamReader in) {
        return in.getEventType() == 1 || in.getEventType() == 2;
    }

    private static void skipUnknownNode(XMLStreamReader in) throws XMLStreamException {
        int levelOfNesting = 0;
        while (in.hasNext()) {
            in.next();
            if (!XmlParserStream.isAtElement(in)) {
                in.nextTag();
            }
            if (in.isStartElement()) {
                ++levelOfNesting;
            }
            if (!in.isEndElement()) continue;
            if (levelOfNesting == 0) break;
            --levelOfNesting;
        }
        in.nextTag();
    }

    private void setValue(SimpleNodeDataWithSchema<?> parent, Object value, NamespaceContext nsContext) {
        DataSchemaNode schema = parent.getSchema();
        Object prev = parent.getValue();
        Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Node '%s' has already set its value to '%s'", (Object)schema.getQName(), (Object)prev);
        parent.setValue(this.translateValueByType(value, schema, nsContext));
    }

    private Object translateValueByType(Object value, DataSchemaNode node, NamespaceContext namespaceCtx) {
        if (node instanceof AnyxmlSchemaNode) {
            Preconditions.checkArgument((boolean)(value instanceof Document));
            return new DOMSource(((Document)value).getDocumentElement());
        }
        if (node instanceof AnydataSchemaNode) {
            Preconditions.checkArgument((boolean)(value instanceof Document));
            return new DOMSourceAnydata(new DOMSource(((Document)value).getDocumentElement()));
        }
        Preconditions.checkArgument((boolean)(node instanceof TypedDataSchemaNode));
        Preconditions.checkArgument((boolean)(value instanceof String));
        return ((XmlCodec)this.codecs.codecFor((TypeAware)((TypedDataSchemaNode)node))).parseValue(namespaceCtx, (String)value);
    }

    private static AbstractNodeDataWithSchema<?> newEntryNode(AbstractNodeDataWithSchema<?> parent) {
        Verify.verify((boolean)(parent instanceof MultipleEntryDataWithSchema), (String)"Unexpected parent %s", parent);
        return ((MultipleEntryDataWithSchema)parent).newChildEntry();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    private Optional<QNameModule> resolveXmlNamespace(String xmlNamespace) {
        return this.resolvedNamespaces.computeIfAbsent(xmlNamespace, nsUri -> {
            Iterator it = this.codecs.getEffectiveModelContext().findModules(URI.create(nsUri)).iterator();
            return it.hasNext() ? Optional.of(((Module)it.next()).getQNameModule()) : Optional.empty();
        });
    }

    private QNameModule rawXmlNamespace(String xmlNamespace) {
        return this.rawNamespaces.computeIfAbsent(xmlNamespace, nsUri -> QNameModule.create((URI)URI.create(nsUri)));
    }

    static {
        TransformerFactory fa = TransformerFactory.newInstance();
        if (!fa.getFeature("http://javax.xml.transform.stax.StAXSource/feature")) {
            LOG.warn("Platform-default TransformerFactory {} does not support StAXSource, attempting fallback to {}", (Object)fa, (Object)COM_SUN_TRANSFORMER);
            fa = TransformerFactory.newInstance(COM_SUN_TRANSFORMER, null);
            if (!fa.getFeature("http://javax.xml.transform.stax.StAXSource/feature")) {
                throw new TransformerFactoryConfigurationError("No TransformerFactory supporting StAXResult found.");
            }
        }
        TRANSFORMER_FACTORY = fa;
    }
}

